import yt.wrapper


REGIONS_TABLE_NAME = "//home/regions/regions"
GATES_TABLE_NAME = "//home/gates/gates"


def delete_table(table_name):
    if yt.wrapper.exists(table_name):
        yt.wrapper.remove(table_name)


def create_table(table_name, schema):
    delete_table(table_name)

    yt.wrapper.create("table", table_name, attributes={"dynamic": True, "schema": schema}, recursive=True)
    yt.wrapper.mount_table(table_name)


def create_regions_table():
    regions_schema = [
        {
            "name": "prefix",
            "required": True,
            "type_v3": "string",
            "sort_order": "ascending",
        },
        {
            "name": "name",
            "required": True,
            "type_v3": "string",
        },
    ]

    create_table(REGIONS_TABLE_NAME, regions_schema)


def create_gates_table():
    gates_schema = [
        {
            "name": "gateid",
            "required": True,
            "type_v3": "string",
            "sort_order": "ascending",
        },
        {
            "name": "aliase",
            "required": True,
            "type_v3": "string",
        },
        {
            "name": "fromname",
            "required": True,
            "type_v3": "string",
        },
        {
            "name": "consumer",
            "required": True,
            "type_v3": "string",
        },
        {
            "name": "contractor",
            "required": True,
            "type_v3": "string",
        },
    ]

    create_table(GATES_TABLE_NAME, gates_schema)
