#! /bin/bash

set -e

create_table(){
    TABLE="$1"
    CLUSTER="$2"
    ROWS="$3"

#    yt --proxy $CLUSTER remove -f $TABLE
    yt --proxy $CLUSTER create --recursive --type table --path $TABLE
    yt --proxy $CLUSTER alter-table $TABLE --dynamic --schema '
<
   "unique_keys" = %true;
   "strict" = %true;
> [
   {
       "name" = "prefix";
       "required" = %true;
       "type_v3" = "string";
       "sort_order" = "ascending";
   };
   {
       "name" = "name";
       "required" = %true;
       "type_v3" = "string";
   };
]
'
    yt --proxy $CLUSTER set $TABLE/@merge_rows_on_flush %true

    yt --proxy $CLUSTER set $TABLE/@min_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@max_data_versions 1
    yt --proxy $CLUSTER set $TABLE/@min_data_ttl 0
    yt --proxy $CLUSTER set $TABLE/@max_data_ttl 0

    yt --proxy $CLUSTER mount-table --sync $TABLE

    if [[ $ROWS ]]; then
        echo "$ROWS" | yt --proxy $CLUSTER insert-rows $TABLE --format json
    fi
}

create_table "//home/passport-rt/development/yasms/config/regions/regions" hahn '
{"prefix": "+", "name": "Other"}
{"prefix": "+20", "name": "Egypt"}
{"prefix": "+225", "name": "C\u00f4te dIvoire"}
{"prefix": "+254", "name": "Kenya"}
{"prefix": "+3670", "name": "Hungary"}
{"prefix": "+372", "name": "Estonia"}
{"prefix": "+373", "name": "Moldova"}
{"prefix": "+374", "name": "Armenia"}
{"prefix": "+37497", "name": "Nagorno-Karabakh"}
{"prefix": "+375", "name": "Belarus"}
{"prefix": "+380", "name": "Ukraine"}
{"prefix": "+49", "name": "Germany"}
{"prefix": "+7", "name": "Russia"}
{"prefix": "+70000", "name": "Test region 1"}
{"prefix": "+70001", "name": "Test region 2"}
{"prefix": "+77", "name": "Kazazhstan"}
{"prefix": "+880", "name": "Bangladesh"}
{"prefix": "+972", "name": "Israel"}
{"prefix": "+994", "name": "Azerbaijan"}
{"prefix": "+996", "name": "Kyrgyzstan"}
{"prefix": "+998", "name": "Uzbekistan"}
{"prefix": "+995", "name": "Georgia"}
{"prefix": "+99833", "name": "Uzbekistan"}
{"prefix": "+735190", "name": "Russia"}
{"prefix": "+33", "name": "France"}
{"prefix": "+44", "name": "UK"}
'
# create_table "//home/passport-rt/testing/yasms/config/regions/regions" hahn
# create_table "//home/passport-rt/production/yasms/config/regions/regions" hahn
