# -*- coding: utf-8 -*-


class BaseError(Exception):
    code = None
    message = None
    http_status_code = 200


class InternalError(BaseError):
    code = u'INTERROR'
    message = u'Internal error, try again later'


class NoSender(BaseError):
    code = u'NOSENDER'
    message = u'No sender defined'


class DontKnowYou(BaseError):
    code = u'DONTKNOWYOU'
    message = u'I don\'t know you (bad IP)'


class NoRights(BaseError):
    code = u'NORIGHTS'
    message = u'Not enough rights'


class TicketInvalid(BaseError):
    code = u'INVALIDTICKET'
    message = u'Ticket invalid'


class TicketMissing(BaseError):
    code = u'NOTICKET'
    message = u'Ticket is missing'


class BadPhone(BaseError):
    code = u'BADPHONE'
    message = u'Bad phone number format'


class BadFromUid(BaseError):
    code = u'BADFROMUID'
    message = u'from_uid has incorrect format'


class NoUid(BaseError):
    code = u'NOUID'
    message = u'User ID not specified'


class NoText(BaseError):
    code = u'NOTEXT'
    message = u'Text not specified'


class NoCurrent(BaseError):
    code = u'NOCURRENT'
    message = u'User does not have an active phone to receive messages'


class PhoneBlocked(BaseError):
    code = u'PERMANENTBLOCK'
    message = u'Number permanently blocked'


class NoRoute(BaseError):
    code = u'NOROUTE'
    message = u'No route to number'


class LimitExceeded(BaseError):
    code = u'LIMITEXCEEDED'
    message = u'Sms limit for this phone exceeded'


class UserDataNotInBody(BaseError):
    code = u'USERDATANOTINBODY'
    message = u'User data cannot be sent outside of request body'


class InvalidTemplateOrParams(BaseError):
    code = u'INVALIDTEMPLATEORPARAMS'
    message = u'Template or params are invalid'


class TextTooLarge(InternalError):
    message = u'Text is too large'


class DBConnectionError(InternalError):
    message = u'Lost DB connection'


class BlackboxError(InternalError):
    message = u'Blackbox request is failed'


class BadUserIp(InternalError):
    message = u'Bad user ip'


class NoNumberOrRouteError(InternalError):
    code = u'NONUMBERORROUTE'


class UnknownUid(NoCurrent):
    message = u'User with given uid was not found'
