# -*- coding: utf-8 -*-
from passport.backend.core import validators
from passport.infra.daemons.yasmsapi.api.forms.common import (
    NormalizablePhoneNumberValidator,
    RouteValidator,
    SmsTextValidator,
)


class SendSmsForm(validators.Schema):
    uid = validators.Uid(if_missing=None)
    from_uid = validators.Uid(if_missing=None)

    phone = NormalizablePhoneNumberValidator(if_missing=None)
    phone_id = validators.PhoneId(if_missing=None, min=0)

    text = SmsTextValidator()
    text_template_params = validators.JSONValidator(
        schema={
            "type": "object",
            "patternProperties": {"^\\w+$": {"type": "string"}},
            "additionalProperties": False,
        },
        if_missing=None,
    )
    allow_unused_text_params = validators.StringBool(if_missing=False)

    sender = validators.String(not_empty=True, strip=True)
    route = RouteValidator()

    gate_id = validators.Int(strip=True, if_missing=None)
    caller = validators.String(strip=True, if_missing=None)
    identity = validators.String(strip=True, if_missing=None)

    previous_gates = validators.ListValidator(
        validator=validators.Int(not_empty=True, min=1),
        if_missing=None,
        not_empty=True,
    )

    scenario = validators.String(strip=True, if_missing=None, max=255)
    device_id = validators.String(strip=True, if_missing=None, max=255)
    request_path = validators.String(strip=True, if_missing=None, max=512)

    chained_validators = [
        validators.RequireIfMissing('uid', missing='phone'),
    ]

    def _to_python(self, value_dict, state=None):
        # Для передачи телефонного номера используются и phone, и number.
        # Оставим одно поле phone, приоритет возьмем из Перла:
        # 'query' предпочтительнее 'body' + 'phone' предпочтительнее 'number'
        phone = value_dict.pop('phone', None)
        number = value_dict.pop('number', None)
        found_phone = phone or number
        if found_phone is not None:
            value_dict.update(
                {
                    'phone': found_phone,
                }
            )

        return super(SendSmsForm, self)._to_python(value_dict, state)
