# -*- coding: utf-8 -*-
import os

import yenv


_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))

if yenv.type == 'development' and _current_user not in ('root', 'www-data'):
    DEBUG = True
else:
    DEBUG = False  # pragma: no cover

LOG_PATH = '' if DEBUG else '/var/log/yandex/yasms/'
STATBOX_PUBLIC_LOG_PATH = LOG_PATH if DEBUG else LOG_PATH + 'statbox/'
STATBOX_PRIVATE_LOG_PATH = LOG_PATH if DEBUG else LOG_PATH + 'statbox/'
GRAPHITE_LOG_PATH = LOG_PATH if DEBUG else LOG_PATH + 'graphite/'

APP_LOGGER_NAME = 'flask'


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'request_id': {
            '()': 'passport.backend.core.logging_utils.filters.RequestIdFilter',
        },
    },
    'formatters': {
        'default': {
            'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'request': {
            'format': '%(asctime)s %(request_id)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'simple': {
            'format': "%(message)s",
        },
    },
    'root': {
        'handlers': ['debug', 'info', 'warning', 'exception'],
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': 'DEBUG',
            'formatter': 'request',
            'filters': ['request_id'],
        },
        'debug': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'debug.log',
            'level': 'DEBUG',
            'formatter': 'request',
            'filters': ['request_id'],
        },
        'info': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'info.log',
            'level': 'INFO',
            'formatter': 'request',
            'filters': ['request_id'],
        },
        'warning': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'warning.log',
            'level': 'WARNING',
            'formatter': 'request',
            'filters': ['request_id'],
        },
        'exception': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'error.log',
            'formatter': 'request',
            'level': 'ERROR',
            'filters': ['request_id'],
        },
        'statbox.public': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': STATBOX_PUBLIC_LOG_PATH + 'statbox.log',
            'formatter': 'simple',
        },
        'statbox.private': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': STATBOX_PRIVATE_LOG_PATH + 'yasms.private.tskv',
            'formatter': 'simple',
        },
        'graphite_logger': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': GRAPHITE_LOG_PATH + 'graphite.log',
            'formatter': 'simple',
        },
    },
    'loggers': {
        'statbox.public': {
            'handlers': ['statbox.public'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'statbox.private': {
            'handlers': ['statbox.private'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.graphite_logger': {
            'handlers': ['graphite_logger'],
            'level': 'DEBUG',
            'propagate': False,
        },
    },
}


if DEBUG:
    LOGGING['root']['handlers'].append('console')
    LOGGING['handlers']['exception'] = {
        'class': 'logging.FileHandler',
        'filename': LOG_PATH + 'exception.log',
        'formatter': 'default',
    }
