PY2_LIBRARY()

OWNER(
    g:passport_infra
)

PEERDIR(
    contrib/python/Flask
    contrib/python/gunicorn
    contrib/python/netaddr
    library/python/yenv
    passport/backend/core
    passport/backend/core/dynamic_config
    passport/backend/library/configurator
    passport/backend/library/wsgi_runner
    passport/infra/daemons/yasmsapi/common
    passport/infra/daemons/yasmsapi/db
)

PY_SRCS(
    __init__.py
    app.py
    configs/__init__.py
    exceptions.py
    forms/__init__.py
    forms/common.py
    forms/routing.py
    forms/send_sms.py
    grants.py
    loggers.py
    logging_utils.py
    sms_encryptor.py
    views/__init__.py
    views/base.py
    views/ping.py
    views/routing.py
    views/send_sms.py
)


RESOURCE(
    configs/base.yaml /etc/yandex/yasms-api/base.yaml
    configs/development.yaml /etc/yandex/yasms-api/development.yaml
    configs/export.yaml /etc/yandex/yasms-api/export.yaml
    configs/logging.yaml /etc/yandex/yasms-api/logging.yaml
    configs/production.yaml /etc/yandex/yasms-api/production.yaml
    configs/rc.yaml /etc/yandex/yasms-api/rc.yaml
    configs/testing.yaml /etc/yandex/yasms-api/testing.yaml
    ping.html /usr/lib/yandex/yasms/ping.html
)

END()

RECURSE(
    bin
)
