# -*- coding: utf-8 -*-
import time

from passport.backend.core.historydb.crypto import encrypt
from passport.backend.core.logging_utils.loggers.statbox import StatboxLogger
from passport.backend.core.logging_utils.loggers.tskv import TskvLogEntry
from passport.infra.daemons.yasmsapi.configs import config


class YasmsStatboxLogEntry(TskvLogEntry):
    sensitive_fields_with_replace = {}

    def __init__(self, **params):
        now = time.time()
        params.setdefault('tskv_format', 'yasms-log')
        params.setdefault('unixtime', int(now))
        params.setdefault('unixtimef', '{:.3f}'.format(now))
        params.setdefault('sms', '1')
        super(YasmsStatboxLogEntry, self).__init__(**params)

    def postprocess_key_and_value(self, key, value):
        if config['historydb_log_encryption_enabled'] and key in self.sensitive_fields_with_replace:
            value = encrypt(value)
            key = self.sensitive_fields_with_replace[key]
        return key, value


class YasmsStatboxPrivateLogEntry(YasmsStatboxLogEntry):
    sensitive_fields_with_replace = {'text': 'encryptedtext'}


class YasmsStatboxPrivateLogger(StatboxLogger):
    """
    В historydb для админки
    """

    default_logger_name = 'statbox.private'
    entry_class = YasmsStatboxPrivateLogEntry


class YasmsStatboxPublicLogger(StatboxLogger):
    """
    Для всех
    """

    default_logger_name = 'statbox.public'
    entry_class = YasmsStatboxLogEntry
