# -*- coding: utf-8 -*-
from passport.infra.daemons.yasmsapi.configs import config
import yenv


# Database validator
# -- permanent blocked phones, ro
# -- routes, ro

_DB_VALIDATOR_SETTINGS = {
    'development': {
        'host': 'cnt-dbm-test.passport.yandex.net',
        'port': 3306,
        'database': 'sms',
        'user': config['db']['validator']['user'],
        'password': config['db']['validator']['password'],
        'driver': 'mysql',
        'charset': 'utf8mb4',
    },
    'testing': {
        'host': 'cnt-dbm-test.passport.yandex.net',
        'port': 3306,
        'database': 'sms',
        'user': config['db']['validator']['user'],
        'password': config['db']['validator']['password'],
        'driver': 'mysql',
        'charset': 'utf8mb4',
    },
    'rc': {
        'host': 'localhost',
        'port': 3306,
        'sock': '/var/run/mysqld/mysqld.sock',
        'database': 'sms',
        'user': config['db']['validator']['user'],
        'password': config['db']['validator']['password'],
        'driver': 'mysql',
        'charset': 'utf8mb4',
    },
    'production': {
        'host': 'localhost',
        'port': 3306,
        'sock': '/var/run/mysqld/mysqld.sock',
        'database': 'sms',
        'user': config['db']['validator']['user'],
        'password': config['db']['validator']['password'],
        'driver': 'mysql',
        'charset': 'utf8mb4',
    },
}

DB_VALIDATOR_SETTINGS = _DB_VALIDATOR_SETTINGS[yenv.type]


# Database smsqueue
# -- sms_queue, rw

_DB_SMS_QUEUE_SETTINGS = {
    'development': {
        'host': 'cnt-dbm-test.passport.yandex.net',
        'port': 3306,
        'database': 'smsqueue',
        'user': config['db']['queue']['user'],
        'password': config['db']['queue']['password'],
        'driver': 'mysql',
    },
    'testing': {
        'host': 'localhost',
        'port': 3306,
        'database': 'smsqueue',
        'user': config['db']['queue']['user'],
        'password': config['db']['queue']['password'],
        'driver': 'mysql',
    },
    'rc': {
        'host': 'localhost',
        'port': 3306,
        'sock': '/var/run/mysqld/mysqld.sock',
        'database': 'smsqueue',
        'user': config['db']['queue']['user'],
        'password': config['db']['queue']['password'],
        'driver': 'mysql',
    },
    'production': {
        'host': 'localhost',
        'port': 3306,
        'sock': '/var/run/mysqld/mysqld.sock',
        'database': 'smsqueue',
        'user': config['db']['queue']['user'],
        'password': config['db']['queue']['password'],
        'driver': 'mysql',
    },
}

DB_SMS_QUEUE_SETTINGS = _DB_SMS_QUEUE_SETTINGS[yenv.type]

DB_QUEUE = 'smsqueue'
DB_VALIDATOR = 'sms'

DB_NAMES = [
    DB_QUEUE,
    DB_VALIDATOR,
]

DEFAULT_CONFIGS = {
    DB_QUEUE: DB_SMS_QUEUE_SETTINGS,
    DB_VALIDATOR: DB_VALIDATOR_SETTINGS,
}
