import json
import logging
import os
from passport.infra.daemons.yasmsapi.tools.keys_generator.src.config import (
    Config,
)
from passport.infra.daemons.yasmsapi.tools.keys_generator.src.utils import (
    update_keys,
)

CONFIG_FILE = '/etc/yandex/yasms/keys_generator.conf'

log = logging.getLogger()


def main():
    conf = Config(CONFIG_FILE)

    logging.basicConfig(filename=conf.log_file, format='%(asctime)s %(levelname)s : %(message)s', level=logging.DEBUG)

    try:
        if os.path.exists(conf.keys_file):
            with open(conf.keys_file, 'r') as f:
                keys = json.load(f)

            ids = [key['id'] for key in keys]
            if ids:
                log.info('Read %d keys with ids: [%d..%d]' % (len(keys), min(ids), max(ids)))
            else:
                log.info('Read 0 keys')
        else:
            # if file does not exist, create a new one
            keys = []

        keys, added, deleted = update_keys(keys, conf.max_keys, conf.create_key_delay)

        if not added and not deleted:
            log.info('Updated keys, no changes.')
            return

        tmp_file = conf.keys_file + '.tmp'

        with open(tmp_file, 'w') as f:
            json.dump(keys, f, indent=2, sort_keys=True)

        os.chmod(tmp_file, 0o600)
        os.rename(tmp_file, conf.keys_file)

    except Exception as e:
        log.warn('Failed to update keys: %s' % e)
        return

    log.info('Successfully updated keys, added keys %s, deleted keys %s' % (added, deleted))
