import json


class Config:
    def __init__(self, filename):
        with open(filename, 'r') as f:
            config = json.load(f)

            # file to write keys
            self.keys_file = config.get('keys_file', '/etc/yandex/yasms/encryption_keys/keys.json')

            # maximum number of keys, keep keys for ~3 days
            self.max_keys = config.get('max_keys', 72)

            # create keys if no new keys in 1 hour
            self.create_key_delay = config.get('create_key_delay', 3600)

            # log file
            self.log_file = config.get('log_file', '/var/log/yandex/yasms/keys_generator.log')
