import time
import os


def add_key(keys_list, now):
    new_id = max([key['id'] for key in keys_list]) + 1 if keys_list else 1

    # generate 256 bit key
    rand = os.urandom(32)

    keys_list.append({'id': new_id, 'create_ts': now, 'body': rand.hex()})

    return new_id


def update_keys(keys, max_keys, create_key_delay, now=int(time.time())):
    added = []
    deleted = []

    # first, generate new key if needed
    newest_key_ts = max([key['create_ts'] for key in keys]) if keys else 0
    if now - newest_key_ts >= create_key_delay:
        added.append(add_key(keys, now))

    keys.sort(key=lambda k: k['create_ts'])

    # delete old keys if we over max_keys
    to_delete = len(keys) - max_keys
    if to_delete > 0:
        deleted = [key['id'] for key in keys[:to_delete]]
        keys = keys[to_delete:]

    return keys, added, deleted
