import json
import sys
import re


MAX_CONNECTIONS = 200
REPLICA_WORKERS = 4
PYTHON_WORKERS = 32
CRON_WORKERS = 1
YASMS_INTERNAL_MAX_CONNECTIONS = 1

QUEUE_WORKERS = MAX_CONNECTIONS - PYTHON_WORKERS * 2 - REPLICA_WORKERS - CRON_WORKERS - YASMS_INTERNAL_MAX_CONNECTIONS

"""
Deprecated: Получение текущего HostID.
Используется только для формирования global sms id (см. globalSmsId).
См. так же: https://wiki.yandex-team.ru/mikhailrozentsvayg/loghostid/
"""
DEFAULT_HOST_ID = 0x7F
HOST_IDS = {
    "yasms-test-v1.passport.yandex.net": 0xE0,
    "yasms-test-s1.passport.yandex.net": 0xE1,
    "yasms-m1.passport.yandex.net": 0x30,
    "yasms-v1.passport.yandex.net": 0x37,
    "yasms-s1.passport.yandex.net": 0x46,
    "yasms-i1.passport.yandex.net": 0x80,
    "cerevra-dev-xenial.passport.yandex.net": DEFAULT_HOST_ID,
    "dimaandreev-dev-bionic.passport.yandex.net": DEFAULT_HOST_ID,
}

"""
Т.к. kannel не умеет вызывать dlr-url callback по IPv6, а для тестинга
данные должны уходить в тестовый historydb, kannel дергает ручку на локальном
nginx, который потом вызывает необходимый callback уже по ipv6.
Для production контура в этом нет необходимости, т.к. statbox логи пишутся
локально и отправляются с самих kannel-ов.
"""
TESTING_DLR_ULR = "http://127.0.0.1:8082/{hostname}:8081/dlr/"
PRODUCTION_DLR_ULR = "http://127.0.0.1:8081/dlr/"

TESTING_KANNEL_HOSTS = [
    "https://kannel-test-f1.passport.yandex.net",
    "https://kannel-test-v1.passport.yandex.net",
]

PRODUCTION_KANNEL_HOSTS = [
    "https://kannel-s1.passport.yandex.net",
    "https://kannel-m1.passport.yandex.net",
]

SETTINGS = {
    "development": {
        "YASMS_INTERNAL_HOST": "http://localhost",
        "YASMS_INTERNAL_PORT": 8201,
        "YASMS_INTERNAL_TVM_ID": 2031390,
        "MAX_CONNECTIONS": MAX_CONNECTIONS,
        "REPLICA_WORKERS": REPLICA_WORKERS,
        "PYTHON_WORKERS": PYTHON_WORKERS,
        "CRON_WORKERS": CRON_WORKERS,
        "QUEUE_WORKERS": QUEUE_WORKERS,
        "DLR_URL": TESTING_DLR_ULR,
        "KANNEL_HOSTS": TESTING_KANNEL_HOSTS,
        "SELF_TVM_ID": 2032602,
        "ANTIFRAUD_HOST": "https://fraud-test.so.yandex-team.ru",
        "ANTIFRAUD_PORT": 443,
        "ANTIFRAUD_TVM_ID": 2024973,
    },
    "testing": {
        "YASMS_INTERNAL_HOST": "http://localhost",
        "YASMS_INTERNAL_PORT": 8201,
        "YASMS_INTERNAL_TVM_ID": 2031392,
        "MAX_CONNECTIONS": MAX_CONNECTIONS,
        "REPLICA_WORKERS": REPLICA_WORKERS,
        "PYTHON_WORKERS": PYTHON_WORKERS,
        "CRON_WORKERS": CRON_WORKERS,
        "QUEUE_WORKERS": QUEUE_WORKERS,
        "DLR_URL": TESTING_DLR_ULR,
        "KANNEL_HOSTS": PRODUCTION_KANNEL_HOSTS,
        "SELF_TVM_ID": 2032604,
        "ANTIFRAUD_HOST": "https://fraud-test.so.yandex-team.ru",
        "ANTIFRAUD_PORT": 443,
        "ANTIFRAUD_TVM_ID": 2024973,
    },
    "production": {
        "YASMS_INTERNAL_HOST": "http://localhost",
        "YASMS_INTERNAL_PORT": 8201,
        "YASMS_INTERNAL_TVM_ID": 2031394,
        "MAX_CONNECTIONS": MAX_CONNECTIONS,
        "REPLICA_WORKERS": REPLICA_WORKERS,
        "PYTHON_WORKERS": PYTHON_WORKERS,
        "CRON_WORKERS": CRON_WORKERS,
        "QUEUE_WORKERS": QUEUE_WORKERS,
        "DLR_URL": PRODUCTION_DLR_ULR,
        "KANNEL_HOSTS": PRODUCTION_KANNEL_HOSTS,
        "SELF_TVM_ID": 2032606,
        "ANTIFRAUD_HOST": "https://fraud.so.yandex-team.ru",
        "ANTIFRAUD_PORT": 443,
        "ANTIFRAUD_TVM_ID": 2019898,
    },
}


def do(template, env, hostname):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    if hostname not in HOST_IDS:
        raise Exception("unknown host: %s" % hostname)

    setts = SETTINGS[env]

    setts["HOST_NAME"] = hostname
    setts["HOST_ID"] = HOST_IDS[hostname]
    setts["DLR_URL"] = setts["DLR_URL"].format(hostname=hostname)

    config = template
    for key, value in setts.items():
        config = re.sub('<<%s>>' % key, json.dumps(value), config)

    if '<<' in config or '>>' in config:
        raise Exception("some options were not specified: %s\n" % config)

    print(config)


if __name__ == '__main__':
    if len(sys.argv) != 4:
        print("Usage: {} <template_file> <env> <hostname>".format(sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2], sys.argv[3])
