package config

import (
	"encoding/json"
	"io/ioutil"
)

type Credentials struct {
	User     string `json:"user"`
	Password string `json:"password"`
}

type YaSMSCredentials struct {
	Queue  *Credentials `json:"queue"`
	Kannel *Credentials `json:"kannel"`
}

func NewYaSMSCredentials(filename string) (*YaSMSCredentials, error) {
	configBuffer, err := ioutil.ReadFile(filename)
	if err != nil {
		return nil, err
	}

	config := &YaSMSCredentials{}
	err = json.Unmarshal(configBuffer, config)
	if err != nil {
		return nil, err
	}

	return config, nil
}
