package errs

import "fmt"

// Неожиданный код ответа HTTP.
type UnexpectedHTTPCodeError struct {
	Actual   int    // Актуальный код.
	Expected int    // Ожидаемый код.
	Content  []byte // Содержимое ответа.
}

// error interface
func (e *UnexpectedHTTPCodeError) Error() string {
	if len(e.Content) > 0 {
		return fmt.Sprintf("unexpected http code - Expected: %d, actual: %d, response: '%s'", e.Expected, e.Actual, string(e.Content))
	}

	return fmt.Sprintf("unexpected http code - Expected: %d, actual: %d", e.Expected, e.Actual)
}

// Неожиданное / ошибочное содержимое ответа HTTP.
type UnexpectedHTTPResponseError struct {
	Actual   []byte // Актуальный ответ.
	Expected []byte // Ожидаемый ответ.
	Message  error  // Ошибка.
}

// error interface
func (e *UnexpectedHTTPResponseError) Error() string {
	if e.Message == nil {
		return fmt.Sprintf("unexpected http response - Expected: '%s', actual: '%s'", string(e.Expected), string(e.Actual))
	}

	return fmt.Sprintf("unexpected http response - '%s', actual: '%s'", e.Message, string(e.Actual))
}
