package fraud

import (
	"net"
	"strconv"
	"time"
)

type AntiFraudAction string

type AntiFraudRetry struct {
	Delay time.Duration
	Count uint64
}

const (
	AntiFraudActionAllow AntiFraudAction = "ALLOW"
	AntiFraudActionDeny  AntiFraudAction = "DENY"
)

type Metadata struct {
	Timestamp   time.Time
	UserPhone   string
	Service     string `json:"service"`
	Scenario    string `json:"scenario"`
	RequestPath string `json:"request_path"`
	UserIP      net.IP `json:"ip"`
	UID         uint64 `json:"uid"`
	UserAgent   string `json:"user_agent"`
	DeviceID    string `json:"device_id"`
	MaskedText  string `json:"masked_text"`
	AttemptNo   uint64
}

func (metadata Metadata) ToStatbox() []string {
	var ip string
	if len(metadata.UserIP) != 0 {
		ip = metadata.UserIP.String()
	}

	return []string{
		"service", metadata.Service,
		"scenario", metadata.Scenario,
		"request_path", metadata.RequestPath,
		"ip", ip,
		"uid", strconv.FormatUint(metadata.UID, 10),
		"user_agent", metadata.UserAgent,
		"device_id", metadata.DeviceID,
	}
}

type Checker interface {
	Host() string
	CheckFraudStatus(metadata Metadata) (*AntiFraudResponse, *AntiFraudRetry, error)
}
