package mock

import (
	"encoding/json"
	"math/rand"
	"net/http"
	"net/http/httptest"
	"time"

	"a.yandex-team.ru/passport/infra/daemons/yasmsd/internal/fraud"
	"a.yandex-team.ru/passport/infra/daemons/yasmsd/internal/kannel"
)

func NewMockAntiFraud() *httptest.Server {
	return httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.RequestURI {
		case "/score":
			_, _ = w.Write(kannel.KannelPingResponse)
		case kannel.KannelStatusHandler:
			response := fraud.AntiFraudResponse{
				Action: "ALLOW",
				Reason: "F_phone_white",
				Status: "success",
				TxID:   "pharma/track-0ba3e592047cd8b69cca28f3078594c350",
			}
			data, _ := json.Marshal(response)

			time.Sleep(time.Duration(rand.Intn(50)+150) * time.Millisecond)
			_, _ = w.Write(data)
		default:
			w.WriteHeader(http.StatusNotFound)
		}
	}))
}
