package mock

import (
	"context"
	"testing"

	"github.com/golang/mock/gomock"

	"a.yandex-team.ru/library/go/yandex/tvm"
	mock_tvm "a.yandex-team.ru/library/go/yandex/tvm/mocks"
)

func NewMockTvmClient(t *testing.T) tvm.Client {
	tvmMock := mock_tvm.NewMockClient(gomock.NewController(t))
	tvmMock.EXPECT().GetServiceTicketForAlias(context.Background(), gomock.Eq("antifraud")).Return("ticket", nil).AnyTimes()
	return tvmMock
}
