package routing

/*
Получение списка гейтов (id, имя smsc в kannel, имя отправителя).

Список используется для сопоставления id гейта в таблице маршрутизации sms, имени
гейта на стороне kannel и проставления необходимого имени отправителя.

Так же id гейтов используются для fallback отправки sms в резервные smsc.
*/

type GateEntry struct {
	ID   uint64
	SmsC string
	From string
}

type GatesProvider interface {
	GateEntry(id uint64) *GateEntry
}

/*
Fallbacks - список гейтов для перемаршрутизации (см. PASSP-20933),
общая схема из <https://wiki.yandex-team.ru/passport/yasms/#fallback>

Сервис - это бизнес-юнит, у которого есть заключенный договор с агрегатором
и свой счет. У каждого сервиса есть хотя бы одно подключение к какому-либо
агрегатору (гейт). Если дефолтный гейт сервиса недоступен, то пробуем другие
в порядке убывания приоритета.
*/

type FallbackEntry struct {
	SmsC string // Имя гейта (smsc).
	From string // Имя отправителя.
}

type FallbacksProvider interface {
	Fallbacks(from, smsc string) []*FallbackEntry
}
