package yasmsint

import (
	"sort"

	"a.yandex-team.ru/passport/infra/daemons/yasmsd/internal/routing"
)

type fallbacksOrderList map[string]map[string][]int16

type fallbacksCollector struct {
	fallbacks FallbacksList
	order     fallbacksOrderList
}

type fallbacksSorter struct {
	fallbacks []*routing.FallbackEntry
	order     []int16
}

func newFallbacksCollector() *fallbacksCollector {
	return &fallbacksCollector{
		fallbacks: make(FallbacksList),
		order:     make(fallbacksOrderList),
	}
}

func (collector *fallbacksCollector) Append(raw *RawFallbackEntry) {
	if _, exists := collector.fallbacks[raw.SrcName]; !exists {
		collector.fallbacks[raw.SrcName] = make(map[string][]*routing.FallbackEntry)
		collector.order[raw.SrcName] = make(map[string][]int16)
	}

	fallbacks := collector.fallbacks[raw.SrcName]
	order := collector.order[raw.SrcName]

	fallbacks[raw.SrcGate] = append(fallbacks[raw.SrcGate], &routing.FallbackEntry{
		SmsC: raw.DstGate,
		From: raw.DstName,
	})
	order[raw.SrcGate] = append(order[raw.SrcGate], raw.Order)

	sort.Sort(&fallbacksSorter{
		fallbacks: fallbacks[raw.SrcGate],
		order:     order[raw.SrcGate],
	})
}

func (collector *fallbacksCollector) Get() FallbacksList {
	return collector.fallbacks
}

func (sorter *fallbacksSorter) Len() int {
	return len(sorter.order)
}

func (sorter *fallbacksSorter) Less(i, j int) bool {
	return sorter.order[i] < sorter.order[j]
}

func (sorter *fallbacksSorter) Swap(i, j int) {
	sorter.fallbacks[i], sorter.fallbacks[j] = sorter.fallbacks[j], sorter.fallbacks[i]
	sorter.order[i], sorter.order[j] = sorter.order[j], sorter.order[i]
}
