package utils

import (
	"io/ioutil"
	"os"
	"strings"
)

// Проверка существования файла.
func FileExists(filename string) (bool, error) {
	stat, err := os.Stat(filename)
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}

		return false, err
	} else if stat.IsDir() {
		return false, nil
	}

	return true, nil
}

// Получение содержимого файла. Если файла не существует, возвращается пустая строка.
func FileContents(filename string) (string, error) {
	exists, err := FileExists(filename)
	if err != nil {
		return "", err
	} else if !exists {
		return "", nil
	}

	buf, err := ioutil.ReadFile(filename)
	if err != nil {
		return "", err
	}

	return strings.TrimSpace(string(buf)), nil
}
