package yasmsd

import (
	"context"
	"os"
	"os/signal"
	"sync"
	"syscall"

	"a.yandex-team.ru/passport/infra/daemons/yasmsd/internal/logs"
)

/*
Монитор системных сигналов и вызов обработчиков сигналов.
*/

// Монитор сигналов.
func SignalMonitor(ctx context.Context, loggers *logs.Logs, wg *sync.WaitGroup) {
	loggers.General.WriteDebug(logs.ComponentSignal, "monitor started")

	ch := make(chan os.Signal, 1)
	signal.Notify(ch, syscall.SIGUSR1)

SIGNAL:
	for {
		select {
		case event := <-ch:
			switch event {
			case syscall.SIGUSR1:
				loggers.General.WriteDebug(logs.ComponentSignal, "received SIGUSR1 - reopen logs")
				// TODO: что лучше - перестать писать логи, но продолжить работу, или логи важнее?
				_ = loggers.ReOpen()
			}
		case <-ctx.Done():
			signal.Stop(ch)
			break SIGNAL
		}
	}

	wg.Done()

	loggers.General.WriteDebug(logs.ComponentSignal, "monitor stopped")
}
