#include <passport/infra/daemons/yasmsd/tools/reporter/src/parser.h>

#include <library/cpp/getopt/small/last_getopt.h>

#include <util/datetime/base.h>
#include <util/stream/output.h>

using namespace NPassport;
using namespace NPassport::NYasmsParser;

// NOLINTNEXTLINE(bugprone-exception-escape)
int main(int argc, char** argv) {
    TString inFile;
    TString outFile;

    NLastGetopt::TOpts opts;
    opts.AddHelpOption();
    opts.AddLongOption("input", "file to parse (default: yesterday)")
        .DefaultValue(
            (TInstant::Now() - TDuration::Days(1))
                .FormatLocalTime("/storage/logs/production/var/log/yandex/yasms/daemon/statbox/yasms.private.tskv.%Y%m%d"))
        .StoreResult(&inFile);
    opts.AddLongOption("output", "tskv file with aggregates")
        .DefaultValue("./yasms.private.report")
        .StoreResult(&outFile);

    NLastGetopt::TOptsParseResult optRes(&opts, argc, argv);

    Cout << "File   : " << inFile << Endl;

    TInstant start = TInstant::Now();
    TParser parser(inFile);
    parser.Parse();
    TInstant parsingFinish = TInstant::Now();
    Cout << "Parsing took: " << (parsingFinish - start) << Endl;

    TStats stats = parser.FetchStats();
    {
        TFileOutput file(outFile);
        stats.PrintTskv(file);
    }

    Cout << Endl << "Postprocessing took: " << (TInstant::Now() - parsingFinish) << Endl;

    return 0;
}
