#! /bin/bash
EMAIL=passport-stats@yandex-team.ru

set -e

trap print_err ERR

print_err()
{
    >&2 echo "failed to complete script"
}

DATE="$1"
if [[ -z $DATE || $DATE == "-" ]]; then
    DATE=$(date -d "-1 day" +'%Y%m%d')
fi

SEND_RETRIES="$2"
if [ -z $SEND_RETRIES ]; then
    SEND_RETRIES="0"
fi

BIN_DIR="/usr/bin/yandex/yasms-reporter"
TMPDIR="/var/lib/yasms-reporter/tmp"
ETC_DIR="/etc/yandex/yasms-reporter"

YT_PATH="//home/passport/production/reports/yasms/private_log/"$DATE

# cleanup
rm -rf $TMPDIR
mkdir $TMPDIR

ulimit -c unlimited

# prepare data
$BIN_DIR/yasms_private_log_parser \
    --input "/storage/logs/production/var/log/yandex/yasms/daemon/statbox/yasms.private.tskv."$DATE \
    --output $TMPDIR/yasms.private.report \
    1> $TMPDIR/private.out \
    2> $TMPDIR/private.err

# send to YT with retries
export YT_TOKEN="$(cat $ETC_DIR/yt.token)"

send_to_yt(){
    yt --proxy hahn remove -f $YT_PATH \
    && yt --proxy hahn create table $YT_PATH >> $TMPDIR/yt.out 2>> $TMPDIR/yt.err \
    && yt --proxy hahn alter-table $YT_PATH --schema "$(cat $ETC_DIR/yt_table.schema)" >> $TMPDIR/yt.out 2>> $TMPDIR/yt.err \
    && cat $TMPDIR/yasms.private.report | yt --proxy hahn write --format dsv --table $YT_PATH >> $TMPDIR/yt.out 2>> $TMPDIR/yt.err \
    && return 0

    return 1
}

SENT_TO_YT=""
while [ $SEND_RETRIES -gt 0 ]
do
    if send_to_yt; then
        SENT_TO_YT="1"
        break
    else
        SEND_RETRIES=$(($SEND_RETRIES-1))
        SLEEP_PERIOD="600"
        echo "Failed to send report. Sleep for $SLEEP_PERIOD seconds" >> $TMPDIR/yt.err
        sleep $SLEEP_PERIOD
    fi
done
if [ -z $SENT_TO_YT ]; then
    send_to_yt
fi
