#include "parser.h"

#include <library/cpp/string_utils/tskv_format/tskv_map.h>

namespace NPassport::NYasmsParser {
    void TParser::ParseLine(TStringBuf line) {
        if (std::optional o = ParseImpl(line); o) {
            Stats_.Map(*o);
        }
    }

    std::optional<TRow> TParser::ParseImpl(TStringBuf line) {
        // Skip "yasms-m1.passport.yandex.net: "
        line.NextTok(": ");

        line.SkipPrefix("tskv\t");
        NTskvFormat::DeserializeMap(line, Parsed_, Buf_);

        auto getStr = [this](const TStringBuf key) {
            auto it = Parsed_.find(key);
            return it == Parsed_.end() || it->second == "<nil>" ? TStringBuf() : it->second;
        };

        if (getStr("action") != "antifraud:check") {
            return {};
        }

        return TRow{
            .Service = getStr("service"),
            .UserIp = getStr("ip"),
            .UserAgent = getStr("user_agent"),
            .DeviceId = getStr("device_id"),
            .RequestPath = getStr("request_path"),
            .Scenario = getStr("scenario"),
        };
    }
}
