#pragma once

#include "stats.h"

#include <passport/infra/libs/cpp/reporter/parser.h>

#include <util/generic/hash.h>

namespace NPassport::NYasmsParser {
    class TParser: public NReporter::TParserBase {
    public:
        using TParserBase::TParserBase;

        TStats FetchStats() {
            return std::move(Stats_);
        }

        void ParseLine(TStringBuf line) override;

        std::optional<TRow> ParseImpl(TStringBuf line);

    private:
        TStats Stats_;

        // allocated memory
        THashMap<TStringBuf, TStringBuf> Parsed_;
        TString Buf_;
    };
}
