#pragma once

#include <util/generic/map.h>

namespace NPassport::NYasmsParser {
    struct TRow {
        TStringBuf Service;
        TStringBuf UserIp;
        TStringBuf UserAgent;
        TStringBuf DeviceId;
        TStringBuf RequestPath;
        TStringBuf Scenario;

        bool operator==(const TRow& o) const {
            return Service == o.Service &&
                   UserIp == o.UserIp &&
                   UserAgent == o.UserAgent &&
                   DeviceId == o.DeviceId &&
                   RequestPath == o.RequestPath &&
                   Scenario == o.Scenario;
        }
    };

    class TConsumer {
    public:
        void Map(const TRow& row);
        void Reduce(TConsumer& to) const;

        void PrintTskv(TStringBuf service, IOutputStream& out) const;

    private:
        ui64 Requests_ = 0;
        ui64 WithUserIp_ = 0;
        ui64 WithUserAgent_ = 0;
        ui64 WithDeviceId_ = 0;
        ui64 WithRequestPath_ = 0;
        ui64 WithScenario_ = 0;
    };

    class TStats {
    public:
        void Map(const TRow& row);
        void Reduce(TStats& to) const;

        void PrintTskv(IOutputStream& out) const;

    private:
        TMap<TString, TConsumer> Consumers_;
    };

    struct TMapper {
        using TRes = std::map<TString, TStats>;
    };
}
