#include <passport/infra/daemons/yasmsd/tools/reporter/src/parser.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NYasmsParser;

Y_UNIT_TEST_SUITE(Parser) {
    Y_UNIT_TEST(ParseImpl) {
        TFileOutput(".empty_file");

        TParser parser(".empty_file");

        for (TStringBuf line : {
                 "",
                 "yasms-v1.passport.yandex.net: tskv	tskv_format=yasms-log	action=kek",
             }) {
            UNIT_ASSERT_VALUES_EQUAL_C(std::optional<TRow>(), parser.ParseImpl(line), line);
        }

        UNIT_ASSERT_VALUES_EQUAL(
            TRow({.Service = "kek", .UserIp = "foo"}),
            parser.ParseImpl("yasms-v1.passport.yandex.net: tskv	action=antifraud:check	service=kek	ip=foo"));
        UNIT_ASSERT_VALUES_EQUAL(
            TRow({.Service = "kek"}),
            parser.ParseImpl("yasms-v1.passport.yandex.net: tskv	action=antifraud:check	service=kek	ip=<nil>"));
        UNIT_ASSERT_VALUES_EQUAL(
            TRow({
                .Service = "kek",
                .UserIp = "foo1",
                .UserAgent = "foo2",
                .DeviceId = "foo3",
                .RequestPath = "foo4",
                .Scenario = "foo5",
            }),
            parser.ParseImpl("yasms-v1.passport.yandex.net: tskv	action=antifraud:check	service=kek	ip=foo1	user_agent=foo2	device_id=foo3	request_path=foo4	scenario=foo5"));
    }
}
