import sys

from passport.infra.daemons.ysa.config.pixel.configurator.generate_nginx_config import run as nginx_config

MODS = {
    'generate-nginx-config': nginx_config,
}

if __name__ == '__main__':
    known_mods = [a[0] for a in MODS.items()]

    if len(sys.argv) < 2:
        raise Exception('Choose mode: %s' % known_mods)

    mode = sys.argv[1]
    if mode not in MODS:
        raise Exception('Unknown mode %s. Known: %s' % (mode, known_mods))

    MODS[mode](sys.argv[2:])
