#include "ysa.h"

#include <passport/infra/daemons/ysa/src/facade.h>

extern "C" {
#include <passport/infra/daemons/ysa/p0f/api.h>
}

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/generic/yexception.h>
#include <util/system/thread.h>

using namespace NPassport;

static void YsaQuery(const p0f_api_query& query, p0f_api_response& response) {
    handle_query((p0f_api_query*)&query, &response);
}

template <class T>
static bool CatchExceptions(const char* func, T lambda) {
    try {
        lambda();
    } catch (const std::exception& e) {
        TLog::Error() << "Exception in '" << func << "': " << e.what();
        return false;
    } catch (...) {
        TLog::Error() << "Exception in '" << func << "': unknown error";
        return false;
    }

    return true;
}

static NYsa::TFacade* YSA = nullptr;

int YsaStart(const char* configFile) {
    TThread::SetCurrentThreadName("pof_main");

    YsaStop();

    bool res = CatchExceptions(
        "start_ysa",
        [configFile]() {
            Y_ENSURE(configFile, "config cannot be NULL");
            YSA = new NYsa::TFacade();
            YSA->Init(configFile, YsaQuery);
            YSA->Start();
        });

    return res ? 0 : 1;
}

void YsaStop() {
    CatchExceptions(
        "stop_ysa",
        []() {
            if (YSA) {
                try {
                    YSA->Stop();
                } catch (const std::exception& e) {
                    TLog::Error() << "stop_ysa: failed to stop: " << e.what();
                }
                delete YSA;
                YSA = nullptr;
            }
        });
}

void YsaProccessRequests() {
    CatchExceptions(
        "ysa_proccess_requests",
        []() {
            if (YSA) {
                YSA->ProccessSomeRequests();
            }
        });
}

void YsaLogFlowNuke(ui32 nuked, ui32 count) {
    CatchExceptions(
        "ysa_log_flow_nuke",
        [=]() {
            TLog::Debug() << "p0f: nuke_flows destroyed " << nuked
                          << ". total: " << count;
        });
}
