/*
   p0f - TLS fingerprinting
 */
#define _FROM_FP_TLS

#include "alloc-inl.h"
#include "config.h"
#include "debug.h"
#include "fp_tls.h"
#include "hash.h"
#include "p0f.h"
#include "process.h"
#include "readfp.h"
#include "tcp.h"
#include "types.h"

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>

#define BUF_LIMIT 16384

#define PROTOCOL_CHANGE_CIPHER_SPEC 20
#define PROTOCOL_HANDSHAKE 22
#define PROTOCOL_APPLICATION 23

u8 process_tls(u8 to_srv, struct packet_flow* f) {
    /* Already decided this flow is not worth tracking? */
    if (f->in_tls < 0)
        return 0;

    /* Already parsed ClientHello */
    if (f->tls_client_hello_recvd)
        return 0;

    /* Only interested in incoming ClientHello */
    if (!to_srv)
        return 0;

    u8* pay = f->request;

    if (pay[0] != PROTOCOL_HANDSHAKE) { /*  && pay[0] != 128 - SSLv3 - not allowed */
        f->in_tls = -1;
        return 0;
    }

    DEBUG("[#] ClientHello received.\n");

    f->in_tls = 1;
    f->tls_client_hello_recvd = 1;

    f->tls_sig.hello_len = f->req_len;
    memcpy(f->tls_sig.hello_packet, f->request, f->req_len);

    return 1;
}
