#pragma once

/*
   p0f - type definitions and minor macros
   ---------------------------------------

   Copyright (C) 2012 by Michal Zalewski <lcamtuf@coredump.cx>

   Distributed under the terms and conditions of GNU LGPL.

 */

#pragma once

#include <util/system/types.h>

#include <stdint.h>

typedef ui8 u8;
typedef ui16 u16;
typedef ui32 u32;
typedef ui64 u64;

typedef i8 s8;
typedef i16 s16;
typedef i32 s32;
typedef i64 s64;

#ifndef MIN
    #define MIN(_a, _b) ((_a) > (_b) ? (_b) : (_a))
    #define MAX(_a, _b) ((_a) > (_b) ? (_a) : (_b))
#endif /* !MIN */

/* Macros for non-aligned memory access. */

#ifdef ALIGN_ACCESS
    #include <string.h>
    #define RD16(_val) ({ u16 _ret; memcpy(&_ret, &(_val), 2); _ret; })
    #define RD32(_val) ({ u32 _ret; memcpy(&_ret, &(_val), 4); _ret; })
    #define RD16p(_ptr) ({ u16 _ret; memcpy(&_ret, _ptr, 2); _ret; })
    #define RD32p(_ptr) ({ u32 _ret; memcpy(&_ret, _ptr, 4); _ret; })
#else
    #define RD16(_val) ((u16)_val)
    #define RD32(_val) ((u32)_val)
    #define RD16p(_ptr) (*((u16*)(_ptr)))
    #define RD32p(_ptr) (*((u32*)(_ptr)))
#endif /* ^ALIGN_ACCESS */
