#pragma once

#include <util/generic/string.h>

#include <optional>
#include <vector>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NYsa {
    class TConfig {
    public:
        TConfig(const TString& cfgFilename);

        struct TGeneral {
            TString Logfile;
        } General;

        struct TCommonHandler {
            TString ForceDownFile;
        } CommonHandler;

        struct TCommonHttp {
            TString ListenAddress = "::1";
            ui16 Port = 0;
            ui32 MaxConnections = 4096;
            ui32 MaxQueueSize = 4096;
            ui32 Threads = 0;
            TString ResponseTimeInQueueHeader = "X-RT-IQ";
            TString ResponseTimeInHandlerHeader = "X-RT-IH";
        } CommonHttp;

        struct TUnistatHttp {
            TString ListenAddress = "::1";
            ui16 Port = 0;
            ui32 MaxConnections = 10;
            ui32 MaxQueueSize = 10;
            ui32 Threads = 2;
        } UnistatHttp;

        struct TProcessor {
            size_t DebtLimit = 10000;
        } Processor;

        struct TPostProcessor {
            ui32 Workers = 1;
            TString StatboxLog;
            TString Uatraits;
        } PostProcessor;

        struct TPixel {
            bool EtagEnabled = false;
            TString SecretFile;
            TString GeodataFile;
            std::vector<TString> Namespaces;
            TString PixelPng;
        };

        struct TMirror {
            TString Namespace;
        };

        std::optional<TPixel> Pixel;
        std::optional<TMirror> Mirror;

    protected:
        static TGeneral ReadGeneral(const NJson::TConfig& config, const TString& point);
        static TCommonHandler ReadCommonHandler(const NJson::TConfig& config, const TString& point);
        static TCommonHttp ReadCommonHttp(const NJson::TConfig& config, const TString& point);
        static TUnistatHttp ReadUnistat(const NJson::TConfig& config, const TString& point);
        static TProcessor ReadProcessor(const NJson::TConfig& config, const TString& point);
        static TPostProcessor ReadPostProcessor(const NJson::TConfig& config, const TString& point);
        static std::optional<TPixel> ReadPixel(const NJson::TConfig& config, const TString& point);
        static std::optional<TMirror> ReadMirror(const NJson::TConfig& config, const TString& point);
    };
}
