#pragma once

#include "config.h"
#include "fingerprint.h"
#include "statbox_logger.h"

#include <util/generic/string.h>

namespace NPassport::NDaemon {
    class TBaseHandler;
    class THttpInterface;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NYsa {
    class TConfig;
    class THttpHandler;
    class TPostProcessor;
    class TProcessor;

    class TFacade {
    public:
        TFacade();
        ~TFacade();

        void Init(const TString& cfgFilename, TCallbackPofQuery callback);

        void Start();
        void Stop();

        void ProccessSomeRequests();

    private:
        static void InitLoggers(const TConfig::TGeneral& config);

        void InitProcessor(const TConfig::TProcessor& config, TCallbackPofQuery callback);
        void InitPostProcessor(const TConfig& config);

        void InitCommonHandler(const TConfig& config);
        void InitUnistatHandler(const TConfig& config);

    private:
        void AddUnistat(NUnistat::TBuilder& builder);
        bool IsOk() const;

    private:
        bool InitFailed_ = true;

        std::unique_ptr<TPostProcessor> PostProcessor_;
        std::unique_ptr<TProcessor> Processor_;

        std::unique_ptr<THttpHandler> CommonHandler_;
        std::unique_ptr<NDaemon::THttpInterface> CommonHttp_;

        std::unique_ptr<NDaemon::TBaseHandler> UnistatHandler_;
        std::unique_ptr<NDaemon::THttpInterface> UnistatHttp_;

        TFingerprintCacheContextPtr FingerprintCtx_;
        TFingerprintCachePtr Fingerprint_;
    };
}
