#pragma once

#include <passport/infra/libs/cpp/cache/cache.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace fingerprint::v1 {
    class BinaryParams;
    class HttpParams;
    class TlsParams;
}

namespace NPassport::NYsa {
    struct TFingerprintData {
        TString Serialized;
        TInstant Start;
    };

    using TFingerprintCachePtr = NCache::TCachePtr<TString, TFingerprintData>;
    using TFingerprintCacheContextPtr = NCache::TContextPtr<TString, TFingerprintData>;

    struct TResponse;
    struct TTlsData;

    class TFingerprintConverter {
    public:
        static TString ToProtobuf(const TResponse& response);

    private:
        static void FillHttp(const TResponse& response, fingerprint::v1::HttpParams& out);
        static void FillBinary(const TResponse& response, fingerprint::v1::BinaryParams& out);
        static void FillTls(const TTlsData& response, fingerprint::v1::TlsParams& out);
    };
}
