#pragma once

#include "fingerprint.h"
#include "http_handler.h"

#include <passport/infra/libs/cpp/cache/cache.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>

namespace NPassport::NYsa::NMirror {
    class THandler: public IHandler {
    public:
        THandler(const TString& nspace, TFingerprintCachePtr cache);

        bool HandleRequest(TStringBuf path, NCommon::TRequest& request, TP0fRequester& p0f) override;
        void AddUnistat(NUnistat::TBuilder& builder) const override;

    protected:
        void ProcessFingerPrint(NCommon::TRequest& request, TP0fRequester& p0f);
        void ProcessCheckClient(NCommon::TRequest& request);
        void ProcessCheckClientWithFingerPrint(NCommon::TRequest& request);

    private:
        const TString Namespace_;
        NUnistat::TTimeStat TimeStats_;

        TFingerprintCachePtr Cache_;
    };
}
