#pragma once

#include "config.h"
#include "http_handler.h"
#include "statbox_logger.h"

#include <library/cpp/geobase/lookup.hpp>

#include <util/random/random.h>

#include <unordered_set>

namespace NPassport::NYsa::NPixel {
    struct TRuntimeContext {
        TRuntimeContext(const TConfig::TPixel& cfg);

        TRuntimeContext(const TRuntimeContext&) = default;

        std::shared_ptr<NGeobase::TLookup> Geobase;
        TString SecretKey;
        bool IsEtagEnabled;
        std::unordered_set<TString> Namespaces;
        TString PixelPng;
    };

    struct TPixelArgs {
        TString Namespace;
        TString Yandexuid;
    };

    struct TEtagArgs {
        TStringBuf InHeaderUserIp;
        TStringBuf InHeaderEtag;
        TStringBuf Yandexuid;
    };

    class THandler: public TPingableHandler {
    public:
        THandler(TRuntimeContext&& ctx, TPingableHandler::TConfig&& pingArgs);

        bool Handle(TStringBuf path, NCommon::TRequest& request, TP0fRequester& p0f) override;

    protected:
        void HandlePixel(NCommon::TRequest& request, const TString& nspace, TP0fRequester& p0f);
        void SendPixel(NCommon::TRequest& request, bool isCached) const;
        void ProcessFingerPrint(NCommon::TRequest& request, TPixelArgs&& args, TP0fRequester& p0f);
        static TString PrintHeaderExpires(TInstant now = TInstant::Now());
        TPixelArgs ValidateArgs(const NCommon::TRequest& request, const TString& nspace) const;

        void ValidateNamespace(const TString& nspace) const;
        static void ValidateYandexuid(const TString& yandexuid);

        bool IsEnabledIp(const TString& userIp) const;

        TEtagData ProcessEtag(const TEtagArgs& request) const;
        bool ExtractEtag(const TStringBuf etag,
                         TString& extractedIp,
                         TString& extractedYandexuid,
                         TString& extractedEuid) const;
        TString GenerateEtag(TStringBuf ip,
                             TStringBuf yandexuid,
                             const TString& previousEuid,
                             TInstant now = TInstant::Now(),
                             ui32 random = RandomNumber<ui32>(10000)) const;

        TString CreateEtagSign(TStringBuf data) const;

    private:
        const TRuntimeContext Runtime_;
    };
}
