#pragma once

#include "config.h"
#include "processor.h"
#include "statbox_logger.h"

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/unistat/absolute.h>

#include <util/thread/lfqueue.h>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NYsa {
    class TP0fRequester {
    public:
        void AddRequest(TRequest&& pofRequest);

    protected:
        NUnistat::TSignalAbsolute<> RequestsCount_ = {"requests.queue"};
        NUnistat::TSignalDiff<> RequestsToProcess_ = {"requests.to_process"};
        TLockFreeQueue<TRequest> Requests_;
    };

    class TP0fProxy: public TP0fRequester {
    public:
        void AddUnistat(NUnistat::TBuilder& builder) const;
        void FetchRequests(TRequests& requests);
    };
    using TP0fPtr = std::unique_ptr<TP0fProxy>;

    class IHandler {
    public:
        virtual ~IHandler() = default;
        virtual bool HandleRequest(TStringBuf path, NCommon::TRequest& request, TP0fRequester& p0f) = 0;
        virtual void AddUnistat(NUnistat::TBuilder&) const {
        }
    };
    using THandler = std::unique_ptr<IHandler>;

    using TCallbackIsOk = std::function<bool()>;

    class TPingableHandler: public IHandler {
    public:
        struct TConfig {
            TString ForceDownFile;
            TCallbackIsOk IsOk;
        };

        TPingableHandler(TConfig config);

        virtual bool Handle(TStringBuf path, NCommon::TRequest& request, TP0fRequester& p0f) = 0;

    private:
        bool HandleRequest(TStringBuf path, NCommon::TRequest& request, TP0fRequester& p0f) final;
        void HandlePing(NCommon::TRequest& request);

    private:
        const TConfig Config_;
    };

    class THttpHandler {
    public:
        THttpHandler(THandler handler);

        void HandleRequest(NCommon::TRequest& request);

        void AddUnistat(NUnistat::TBuilder& builder) const;

        void GetRequests(TRequests& requests);

    private:
        const THandler Handler_;

        TP0fPtr P0f_;
    };
}
