#pragma once

#include "config.h"
#include "fingerprint.h"
#include "processor.h"
#include "statbox_logger.h"
#include "uatraits.h"

#include <passport/infra/libs/cpp/unistat/absolute.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/utils/regular_task.h>

#include <util/thread/lfqueue.h>

#include <vector>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NYsa {
    class TPostProcessor {
    public:
        TPostProcessor(TStatboxLoggerPtr statbox,
                       TUaTraitsProcessorPtr uatraits,
                       TFingerprintCachePtr fingerprint = nullptr);
        virtual ~TPostProcessor() = default;

        void Add(const TResponses& responses);
        void AddUnistat(NUnistat::TBuilder& builder) const;

        void Start(const TConfig::TPostProcessor& config);
        void Stop();

    protected:
        void Run();
        virtual bool Proc(TResponse& response) const;

    private:
        TStatboxLoggerPtr Statbox_;
        TUaTraitsProcessorPtr Uatraits_;
        TFingerprintCachePtr Fingerprint_;
        TLockFreeQueue<TResponse> Responses_;
        NUnistat::TSignalAbsolute<> ResponseCount_ = {"responses.queue"};
        NUnistat::TSignalDiff<> ResponseErrors_ = {"responses.error"};
        NUnistat::TTimeStat TimeStats_;
        mutable NUnistat::TSignalHistogram<> FingerprintSize_;

        // must be last member
        std::vector<std::unique_ptr<NUtils::TRegularTask>> Workers_;
    };
}
