#pragma once

extern "C" {
#include <passport/infra/daemons/ysa/p0f/api.h>
}

#include <passport/infra/libs/cpp/request/ci_map.h>
#include <passport/infra/libs/cpp/unistat/absolute.h>

#include <util/draft/ip.h>
#include <util/generic/string.h>

#include <functional>
#include <list>
#include <map>
#include <string>
#include <vector>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NYsa {
    using TCallbackPofQuery = std::function<void(const p0f_api_query&, p0f_api_response&)>;
    using TSuspiciousCookies = std::vector<std::pair<TString, TString>>;

    struct TEtagData {
        TString OriginalHeader;
        TString NewHeader;
        TString Euid;
        TString Ip;
        TString Yandexuid;

        bool MalformedEtag = false;
    };

    struct TRequest {
    public:
        TRequest();
        TRequest(const TString& requestId);

    public:
        NCommon::THttpHeaders Headers;
        TString Namespace;
        TString Yandexuid;
        TInstant CreationTime;
        std::optional<TEtagData> Etag;

        const TString& RequestId() const {
            return RequestId_;
        }

        const TString& UserIp() const {
            InitLazy();
            return UserIp_;
        }

        ui16 UserPort() const {
            InitLazy();
            return UserPort_;
        }

        const TString& ServerIp() const {
            InitLazy();
            return ServerIp_;
        }

        ui16 ServerPort() const {
            InitLazy();
            return ServerPort_;
        }

    private:
        void InitLazy() const;

    private:
        TString RequestId_;

        mutable TString UserIp_;
        mutable ui16 UserPort_ = 0;
        mutable TString ServerIp_;
        mutable ui16 ServerPort_ = 0;
    };
    using TRequests = std::vector<TRequest>;

    class TFingerprint {
    public:
        const p0f_api_response& GetPof() const {
            return PofResponse_;
        }
        bool CheckResponse() const;
        bool IsConnectionSecure() const;

        p0f_api_response& MutatePof() {
            return PofResponse_;
        }
        void ResetPofResponose(char c = 0);

    private:
        p0f_api_response PofResponse_{};
    };
    using TFingerprintPtr = std::shared_ptr<TFingerprint>;

    struct TUaTraits {
        using TData = std::map<std::string, std::string>;

        TData Data;
    };

    struct TTlsData {
        using TExtensions = std::vector<std::pair<TStringBuf, TStringBuf>>;

        std::vector<TStringBuf> Ciphersuites;
        TStringBuf CompressionMethods;
        TExtensions Extensions;

        ui16 ProtocolVersion = 0;
        ui16 ClientVersion = 0;

        bool IsProtocolVersionSuspicious = false;
        bool IsClientVersionSuspicious = false;
        bool IsRecordSizeSuspicious = false;
        bool IsHadshakeSizeSuspicious = false;
        bool IsSessionidSizeSuspicious = false;
        bool IsCiphersuitesSizeSuspicious = false;
        bool IsCompressionSizeSuspicious = false;
        bool IsAllExtensionsSizeSuspicious = false;
        bool IsExtensionSizeSuspicious = false;
    };

    struct TResponse {
        TFingerprintPtr Finger;
        TString Error;
        TRequest Request;
        TUaTraits UaTraits;
        std::optional<TTlsData> Tls;
        TInstant FetchTime;

        bool IsReturnable() const {
            return Finger || Error;
        }
    };
    using TResponses = std::vector<TResponse>;

    class TProcessor {
    public:
        TProcessor(size_t debtLimit, TCallbackPofQuery callback);
        virtual ~TProcessor() = default;

        TRequests& GetRequestsStorage() {
            return Requests_;
        }

        TResponses Run(TInstant now = TInstant::Now());
        size_t GetDebtSize() const; // for tests
        void AddUnistat(NUnistat::TBuilder& builder) const;

    protected:
        TResponse RunOne(const TRequest& request) const;
        static void ReturnResponse(TRequest&& request, TResponse&& resp, TResponses& resps);

        void Proc(const TRequest& request, TResponse& res) const;

        virtual TFingerprintPtr MakeQuery(const TIp4Or6& userIp,
                                          ui16 userPort,
                                          const TIp4Or6& serverIp,
                                          ui16 serverPort) const;

        static p0f_api_query PrepareQuery(const TIp4Or6& userIp,
                                          ui16 userPort,
                                          const TIp4Or6& serverIp,
                                          ui16 serverPort);

    private:
        TRequests Requests_;
        std::list<TRequest> Debt_;
        NUnistat::TSignalAbsolute<> DebtSize_ = {"requests.debt"};
        const size_t DebtLimit_;
        const TCallbackPofQuery CallbackForQuery_;
    };
}
