#pragma once

#include "processor.h"

#include <passport/infra/libs/cpp/utils/log/file_logger.h>

#include <library/cpp/string_utils/tskv_format/builder.h>

#include <memory>
#include <time.h>

namespace NPassport::NYsa {
    class TStatboxLogEntry;

    class TTlsLogEntry {
    public:
        TTlsLogEntry(TStatboxLogEntry& parent);

        void Log(const TTlsData& response);

        void LogCiphersuites(const std::vector<TStringBuf>& ciph);
        void LogCompressionMethods(const TStringBuf compression);
        void LogExtensions(const TTlsData::TExtensions& extensions);

        void LogVersions(const TTlsData& response);
        void LogSuspicious(const TTlsData& response);

    private:
        void LogAsHex(TStringBuf data);

        template <typename T>
        void LogAsHex(T data);
        void LogCommaSeparated(TStringBuf data);

    private:
        TStringStream Buf_;
        TStatboxLogEntry& Parent_;
    };

    class TStatboxLogEntry {
    public:
        static TString LogOk(const TResponse& response, TInstant now);

    protected:
        TStatboxLogEntry();

        void LogCommon(const TString& nspace, TInstant now);

        void LogHttpParams(const TResponse& response);
        void LogHeaders(const NCommon::THttpHeaders& headers);
        void LogUserAgentInfo(const TUaTraits& uatraits);
        void LogEtag(const TEtagData& etagData);

        void LogBinaryData(const TResponse& response);
        void LogPof(const p0f_api_flow_response& response);
        void LogSynInfo(const p0f_api_flow_tcp_sig& info);
        void LogQuirks(const u32 quirks);

        template <typename T>
        TStringBuf CastNumber(T num);

    protected:
        friend class TTlsLogEntry;

        NTskvFormat::TLogBuilder Builder_;
        char CastBuffer_[48]{};
    };

    class TStatboxLogger {
    public:
        TStatboxLogger(const TString& filename);

        void LogFingerprintOk(const TResponse& response, TInstant now = TInstant::Now()) const;

    private:
        std::unique_ptr<NUtils::TFileLogger> Logger_;
    };
    using TStatboxLoggerPtr = std::shared_ptr<TStatboxLogger>;

    static inline TStatboxLoggerPtr CreateDummyStatbox() {
        return std::make_shared<TStatboxLogger>("/dev/null");
    }
}
