#pragma once

#include "processor.h"

#include <util/generic/strbuf.h>

struct tls_sig;

namespace NPassport::NYsa {
    struct TTlsData;

    class TTlsHelper {
    public:
        static TTlsData CheckTls(const tls_sig& sig);

    public:
        TTlsHelper(TStringBuf data);

        void Parse();

        void ReadRecordHeader();
        void ReadHandshakeHeader();
        void ReadClientVersion();
        void ReadClientRandom();
        void ReadSessionId();
        void ReadCipherSuites();
        void ReadCompressionMethods();
        void ReadExtensions();

        ui8 Get1byteNumber();
        ui16 Get2bytesNumber();
        ui32 Get3bytesNumber();
        TStringBuf GetBytes(size_t size);

        const TTlsData& Result() const {
            return Result_;
        }

    private:
        template <typename T, int N>
        T GetNumber() {
            Y_ENSURE(Data_.size() >= N,
                     "not enough bytes: need " << N << DbgInfoWithPos());

            T res = 0;
            for (size_t idx = 0; idx < N; ++idx) {
                res |= ((ui8)Data_[idx]) << (8 * (N - 1 - idx));
            }

            Data_.Skip(N);
            return res;
        }

        TString DbgInfoWithPos(i32 diff = 0) const;
        size_t GetCurrentPos() const;

        void UpdateSectionDetails(TStringBuf details);

    private:
        TTlsData Result_;

        size_t SectionPos_ = 0;
        TStringBuf SectionDetails_;
        std::optional<size_t> LastExtensionPos_;

        TStringBuf Data_;
        const TStringBuf OriginalData_;
    };
}
