#include "uatraits.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/user_agent/browser_detector.h>

#include <util/stream/file.h>
#include <util/string/ascii.h>

namespace NPassport::NYsa {
    static NUserAgent::TBrowserDetector& GetInstanse() {
        return NUserAgent::TBrowserDetector::Instance();
    }

    TUaTraitsProcessor::TUaTraitsProcessor(const TString& filename) {
        TFileInput file(filename);
        Y_ENSURE(GetInstanse().InitializeUatraitsFromMemory(file.ReadAll()),
                 "failed to initialize uatraits");
    }

    TUaTraits TUaTraitsProcessor::Fetch(const TString& userAgent) const {
        Y_UNUSED(this); // let it look like OOP, but not globally initialized data

        try {
            TUaTraits data{GetInstanse().GetUatraitsData(userAgent)};
            Filter(data.Data);
            return data;
        } catch (const std::exception& e) {
            TLog::Error() << "Exception in uatraits for ua '" << userAgent << "': " << e.what();
        }

        return {};
    }

    static const std::string ONE_ = "1";
    static const std::string ZERO_ = "0";
    void TUaTraitsProcessor::Filter(TUaTraits::TData& data) {
        for (auto it = data.begin(); it != data.end();) {
            if (it->second.empty() || "Unknown" == it->second) {
                data.erase(it++);
                continue;
            }

            if (AsciiEqualsIgnoreCase("true", it->second)) {
                it->second = ONE_;
            } else if (AsciiEqualsIgnoreCase("false", it->second)) {
                it->second = ZERO_;
            }

            ++it;
        }
    }
}
