#include <passport/infra/daemons/ysa/src/fingerprint.h>
#include <passport/infra/daemons/ysa/src/tls_helper.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NYsa;
using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(Fingerprint) {
    static const TString DATA_TLS12 = Hex2bin("16030300f2010000ee03035ce668f6eca006e477a5170fa3ed36db5b38a04a2a1f843d694ed82e85b87d4400006cc02bc02cc086c087c009c023c00ac024c072c073c0acc0adc008c02fc030c08ac08bc013c027c014c028c076c077c012009c009dc07ac07b002f003c0035003d004100ba008400c0c09cc09d000a009e009fc07cc07d003300670039006b004500be008800c4c09ec09f0016010000590017000000160000000500050100000000ff0100010000230000000a000c000a00170018001900150013000b00020100000d0016001404010403050105030601060303010303020102030010000b000908687474702f312e31");

    Y_UNIT_TEST(convert) {
        TResponse resp;
        resp.Request.Headers["X-Real-Ip"] = "kek";
        resp.Request.Headers["X-Real-Port"] = "45678";
        resp.Request.Headers["X-Server-Ip"] = "lol";
        resp.Request.Headers["X-Server-Port"] = "12345";
        resp.Request.Headers["X-Ya-foo"] = "bar";
        resp.Request.Headers["X-Ya-kek"] = "";
        resp.UaTraits.Data["empty_data"] = "";
        resp.UaTraits.Data["Mega_Data"] = "asdklas\n\t\"aosidas";
        resp.Finger = std::make_shared<TFingerprint>();
        resp.Finger->ResetPofResponose(1);

        TTlsHelper h(DATA_TLS12);
        UNIT_ASSERT_NO_EXCEPTION(h.Parse());
        resp.Tls = h.Result();

        UNIT_ASSERT_VALUES_EQUAL(
            "CikyA2tlazju5AJCHgoJTWVnYV9EYXRhEhFhc2RrbGFzCgkiYW9zaWRhcxKeAwiBgoQIEIGChAgYASABKIGChAgwgYKECDiBgoQIQAFIAVABWIGChAhggQJoAXCBAngByAEB2AEBgQIAAAAAAADwP4oC2AIKAsArCgLALAoCwIYKAsCHCgLACQoCwCMKAsAKCgLAJAoCwHIKAsBzCgLArAoCwK0KAsAICgLALwoCwDAKAsCKCgLAiwoCwBMKAsAnCgLAFAoCwCgKAsB2CgLAdwoCwBIKAgCcCgIAnQoCwHoKAsB7CgIALwoCADwKAgA1CgIAPQoCAEEKAgC6CgIAhAoCAMAKAsCcCgLAnQoCAAoKAgCeCgIAnwoCwHwKAsB9CgIAMwoCAGcKAgA5CgIAawoCAEUKAgC+CgIAiAoCAMQKAsCeCgLAnwoCABYSAQAaBAoCABcaBAoCABYaCwoCAAUSBQEAAAAAGgcKAv8BEgEAGgQKAgAjGhIKAgAKEgwACgAXABgAGQAVABMaCAoCAAsSAgEAGhwKAgANEhYAFAQBBAMFAQUDBgEGAwMBAwMCAQIDGhEKAgAQEgsACQhodHRwLzEuMSCDBiiDBg==",
            BinToBase64(TFingerprintConverter::ToProtobuf(resp)));
    }
}
