#include <passport/infra/daemons/ysa/src/handler_mirror.h>

#include <passport/infra/libs/cpp/request/test/request.h>
#include <passport/infra/libs/cpp/unistat/builder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NYsa;

Y_UNIT_TEST_SUITE(FingerprintHandler) {
    class TTestHttpHandler: public NMirror::THandler {
    public:
        using THandler::HandleRequest;
        using THandler::THandler;
    };

    static TFingerprintCachePtr CreateCache() {
        auto ctx = std::make_shared<NCache::TContext<TString, TFingerprintData>>(
            1024 * 1024 * 1024,
            "somename");
        return ctx->CreateCache(3, 32, "requestId");
    }

    Y_UNIT_TEST(noRequiredHeaders) {
        TP0fProxy p0f;
        NTest::TRequest request;
        TRequests out;
        TTestHttpHandler handler("mirror", CreateCache());

        for (const TString& method : {"GET", "POST", "PUT", "OPTIONS"}) {
            for (const TString& path : {"/ping", "/etc/passwd", "test", ""}) {
                request.Method = method;
                UNIT_ASSERT(handler.HandleRequest(path, request, p0f));
                UNIT_ASSERT_VALUES_EQUAL(HTTP_OK, request.Status);
                UNIT_ASSERT_VALUES_EQUAL("", request.Response);
                request.Response.clear();
            }
        }
        p0f.FetchRequests(out);
        UNIT_ASSERT(out.empty());
    }

    Y_UNIT_TEST(hasRequiredHeaders) {
        TP0fProxy p0f;
        NTest::TRequest request;
        TRequests out;
        TTestHttpHandler handler("mirror", CreateCache());

        request.InHeaders["X-Real-Ip"] = "188.170.175.29";
        request.InHeaders["X-Real-Port"] = "вася";
        request.InHeaders["X-Server-Ip"] = "run";
        request.InHeaders["X-Server-Port"] = "!";
        request.InHeaders["X-Request-Id"] = "abcdef";

        for (const TString& method : {"GET", "POST", "PUT", "OPTIONS"}) {
            for (const TString& path : {"/ping", "/etc/passwd", "test", ""}) {
                request.Method = method;
                UNIT_ASSERT(handler.HandleRequest(path, request, p0f));
                UNIT_ASSERT_VALUES_EQUAL(HTTP_OK, request.Status);
                UNIT_ASSERT_VALUES_EQUAL("", request.Response);
                request.Response.clear();
            }
        }
        p0f.FetchRequests(out);
        UNIT_ASSERT_VALUES_EQUAL(16, out.size());
    }
}
