#include <passport/infra/daemons/ysa/src/post_processor.h>

#include <passport/infra/libs/cpp/unistat/builder.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NYsa;

Y_UNIT_TEST_SUITE(PostProcessor) {
    TUaTraitsProcessorPtr CreateUatriats() {
        return std::make_unique<TUaTraitsProcessor>(
            ArcadiaSourceRoot() + "/passport/infra/daemons/ysa/ut/browser.xml");
    }

    static TString GetUnistat(const TPostProcessor& p) {
        TString unistat;
        NUnistat::TBuilder root(unistat);
        p.AddUnistat(root);
        return unistat;
    }

    static TFingerprintCachePtr CreateCache() {
        auto ctx = std::make_shared<NCache::TContext<TString, TFingerprintData>>(
            1024 * 1024 * 1024,
            "somename");
        return ctx->CreateCache(3, 32, "requestId");
    }

    Y_UNIT_TEST(runSimple) {
        class TTestPostProcessor: public TPostProcessor {
        public:
            TTestPostProcessor()
                : TPostProcessor(CreateDummyStatbox(), CreateUatriats(), CreateCache())
            {
            }

            using TPostProcessor::Run;
            using TPostProcessor::TPostProcessor;

            bool Proc(TResponse&) const override {
                ++Count;
                return false;
            }

            mutable NPassport::NUtils::TAtomicNum<> Count;
        };

        TTestPostProcessor p;
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",0],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,0],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]],["fingerprint.size_dhhh",[[0,0],[50,0],[100,0],[150,0],[200,0],[250,0],[300,0],[350,0],[400,0],[450,0],[500,0],[550,0],[600,0],[650,0],[700,0],[750,0],[800,0],[850,0],[900,0],[950,0],[1000,0],[1050,0],[1100,0],[1150,0],[1200,0],[1250,0],[1300,0],[1350,0],[1400,0],[1450,0],[1500,0],[1550,0],[1600,0],[1650,0],[1700,0],[1750,0],[1800,0],[1850,0],[1900,0],[1950,0],[2000,0],[2050,0],[2100,0],[2150,0],[2200,0],[2250,0],[2300,0],[2350,0],[2400,0],[2450,0]]]])",
                                 GetUnistat(p));

        p.Run();
        UNIT_ASSERT_VALUES_EQUAL(0, p.Count.GetValue());

        for (size_t idx = 0; idx < 3; ++idx) {
            p.Add({TResponse()});
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",3],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,0],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]],["fingerprint.size_dhhh",[[0,0],[50,0],[100,0],[150,0],[200,0],[250,0],[300,0],[350,0],[400,0],[450,0],[500,0],[550,0],[600,0],[650,0],[700,0],[750,0],[800,0],[850,0],[900,0],[950,0],[1000,0],[1050,0],[1100,0],[1150,0],[1200,0],[1250,0],[1300,0],[1350,0],[1400,0],[1450,0],[1500,0],[1550,0],[1600,0],[1650,0],[1700,0],[1750,0],[1800,0],[1850,0],[1900,0],[1950,0],[2000,0],[2050,0],[2100,0],[2150,0],[2200,0],[2250,0],[2300,0],[2350,0],[2400,0],[2450,0]]]])",
                                 GetUnistat(p));
        p.Run();
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",0],["responses.error_dmmm",3],["request.proc.time_dhhh",[[0,3],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]],["fingerprint.size_dhhh",[[0,0],[50,0],[100,0],[150,0],[200,0],[250,0],[300,0],[350,0],[400,0],[450,0],[500,0],[550,0],[600,0],[650,0],[700,0],[750,0],[800,0],[850,0],[900,0],[950,0],[1000,0],[1050,0],[1100,0],[1150,0],[1200,0],[1250,0],[1300,0],[1350,0],[1400,0],[1450,0],[1500,0],[1550,0],[1600,0],[1650,0],[1700,0],[1750,0],[1800,0],[1850,0],[1900,0],[1950,0],[2000,0],[2050,0],[2100,0],[2150,0],[2200,0],[2250,0],[2300,0],[2350,0],[2400,0],[2450,0]]]])",
                                 GetUnistat(p));
        UNIT_ASSERT_VALUES_EQUAL(3, p.Count.GetValue());
    }

    Y_UNIT_TEST(runExcept) {
        class TTestPostProcessor: public TPostProcessor {
        public:
            TTestPostProcessor()
                : TPostProcessor(CreateDummyStatbox(), CreateUatriats(), CreateCache())
            {
            }

            using TPostProcessor::Run;
            using TPostProcessor::TPostProcessor;

            bool Proc(TResponse&) const override {
                ++Count;
                if (Count.GetValue() == 1) {
                    ythrow yexception();
                }
                return true;
            }

            mutable NPassport::NUtils::TAtomicNum<> Count;
        };

        TTestPostProcessor p;
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",0],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,0],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]],["fingerprint.size_dhhh",[[0,0],[50,0],[100,0],[150,0],[200,0],[250,0],[300,0],[350,0],[400,0],[450,0],[500,0],[550,0],[600,0],[650,0],[700,0],[750,0],[800,0],[850,0],[900,0],[950,0],[1000,0],[1050,0],[1100,0],[1150,0],[1200,0],[1250,0],[1300,0],[1350,0],[1400,0],[1450,0],[1500,0],[1550,0],[1600,0],[1650,0],[1700,0],[1750,0],[1800,0],[1850,0],[1900,0],[1950,0],[2000,0],[2050,0],[2100,0],[2150,0],[2200,0],[2250,0],[2300,0],[2350,0],[2400,0],[2450,0]]]])",
                                 GetUnistat(p));

        p.Run();
        UNIT_ASSERT_VALUES_EQUAL(0, p.Count.GetValue());

        for (size_t idx = 0; idx < 3; ++idx) {
            p.Add({TResponse()});
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",3],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,0],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]],["fingerprint.size_dhhh",[[0,0],[50,0],[100,0],[150,0],[200,0],[250,0],[300,0],[350,0],[400,0],[450,0],[500,0],[550,0],[600,0],[650,0],[700,0],[750,0],[800,0],[850,0],[900,0],[950,0],[1000,0],[1050,0],[1100,0],[1150,0],[1200,0],[1250,0],[1300,0],[1350,0],[1400,0],[1450,0],[1500,0],[1550,0],[1600,0],[1650,0],[1700,0],[1750,0],[1800,0],[1850,0],[1900,0],[1950,0],[2000,0],[2050,0],[2100,0],[2150,0],[2200,0],[2250,0],[2300,0],[2350,0],[2400,0],[2450,0]]]])",
                                 GetUnistat(p));
        p.Run();
        UNIT_ASSERT_VALUES_EQUAL(3, p.Count.GetValue());
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",0],["responses.error_dmmm",1],["request.proc.time_dhhh",[[0,3],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]],["fingerprint.size_dhhh",[[0,0],[50,0],[100,0],[150,0],[200,0],[250,0],[300,0],[350,0],[400,0],[450,0],[500,0],[550,0],[600,0],[650,0],[700,0],[750,0],[800,0],[850,0],[900,0],[950,0],[1000,0],[1050,0],[1100,0],[1150,0],[1200,0],[1250,0],[1300,0],[1350,0],[1400,0],[1450,0],[1500,0],[1550,0],[1600,0],[1650,0],[1700,0],[1750,0],[1800,0],[1850,0],[1900,0],[1950,0],[2000,0],[2050,0],[2100,0],[2150,0],[2200,0],[2250,0],[2300,0],[2350,0],[2400,0],[2450,0]]]])",
                                 GetUnistat(p));
    }

    Y_UNIT_TEST(run) {
        class TTestPostProcessor: public TPostProcessor {
        public:
            TTestPostProcessor()
                : TPostProcessor(CreateDummyStatbox(), CreateUatriats())
            {
            }

            using TPostProcessor::Run;
            using TPostProcessor::TPostProcessor;

            bool Proc(TResponse&) const override {
                if (Count.GetValue() == 0) {
                    EvProc.Signal();
                    EvAdd.WaitI();
                }

                ++Count;
                return true;
            }

            mutable NPassport::NUtils::TAtomicNum<> Count;
            mutable TAutoEvent EvProc;
            mutable TAutoEvent EvAdd;
        };

        TTestPostProcessor p;
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",0],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,0],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]]])",
                                 GetUnistat(p));
        UNIT_ASSERT_VALUES_EQUAL(0, p.Count.GetValue());

        for (size_t idx = 0; idx < 3; ++idx) {
            p.Add({TResponse()});
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",3],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,0],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]]])",
                                 GetUnistat(p));
        std::thread t([&p]() { p.Run(); });

        p.EvProc.WaitI();
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",0],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,1],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]]])",
                                 GetUnistat(p));
        for (size_t idx = 0; idx < 10; ++idx) {
            p.Add({TResponse()});
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",10],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,1],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]]])",
                                 GetUnistat(p));
        p.EvAdd.Signal();

        t.join();

        UNIT_ASSERT_VALUES_EQUAL(R"([["responses.queue_avvv",0],["responses.error_dmmm",0],["request.proc.time_dhhh",[[0,13],[1,0],[2,0],[3,0],[4,0],[5,0],[6,0],[7,0],[8,0],[9,0],[10,0],[12,0],[15,0],[17,0],[20,0],[25,0],[30,0],[35,0],[40,0],[45,0],[50,0],[60,0],[70,0],[80,0],[90,0],[100,0],[125,0],[150,0],[175,0],[200,0],[225,0],[250,0],[275,0],[300,0],[400,0],[500,0],[750,0],[1000,0],[2000,0],[3000,0]]]])",
                                 GetUnistat(p));
        UNIT_ASSERT_VALUES_EQUAL(13, p.Count.GetValue());
    }
}
