#include <passport/infra/daemons/ysa/src/statbox_logger.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NYsa;

Y_UNIT_TEST_SUITE(Statbox) {
    class TTestStatboxLogEntry: public TStatboxLogEntry {
    public:
        using TStatboxLogEntry::Builder_;
        using TStatboxLogEntry::LogCommon;
        using TStatboxLogEntry::LogHeaders;
    };

    Y_UNIT_TEST(ok) {
        TResponse resp;
        resp.Request.Namespace = "kek";
        UNIT_ASSERT_VALUES_EQUAL("tskv\t"
                                 "tskv_format=passport-ysa-log\t"
                                 "mode=fingerprint_external_dump\t"
                                 "namespace=kek\t"
                                 "unixtime=100500.007\t"
                                 "status=not_found\n",
                                 TTestStatboxLogEntry::LogOk(
                                     resp,
                                     TInstant::Seconds(100500) + TDuration::MilliSeconds(7)));

        resp.Request.Yandexuid = "uid\n1";
        resp.Request.Headers["X-Real-Ip"] = "kek";
        resp.Request.Headers["X-Real-Port"] = "lol";
        resp.Request.Headers["X-Ya-foo"] = "bar";
        resp.Request.Etag = TEtagData();
        resp.Request.Etag->MalformedEtag = true;
        resp.Request.Etag->OriginalHeader = "originalHeader";
        UNIT_ASSERT_VALUES_EQUAL("tskv\t"
                                 "tskv_format=passport-ysa-log\t"
                                 "mode=fingerprint_external_dump\t"
                                 "namespace=kek\t"
                                 "unixtime=100500.007\t"
                                 "user_port=lol\t"
                                 "user_ip=kek\t"
                                 "etag_euid=\t"
                                 "etag_ip=\t"
                                 "etag_yandexuid=\t"
                                 "etag_malformed=1\t"
                                 "etag_original_header=originalHeader\t"
                                 "yandexuid=uid\\n1\t"
                                 "status=not_found\n",
                                 TTestStatboxLogEntry::LogOk(
                                     resp,
                                     TInstant::Seconds(100500) + TDuration::MilliSeconds(7)));

        resp.Request.Headers["X-Ya-kek"] = "";
        resp.UaTraits.Data["empty_data"] = "";
        resp.UaTraits.Data["Mega_Data"] = "asdklas\n\t\"aosidas";
        resp.Request.Etag->MalformedEtag = false;
        resp.Finger = std::make_shared<TFingerprint>();
        resp.Finger->ResetPofResponose(1);
        resp.Tls = TTlsData();

        UNIT_ASSERT_VALUES_EQUAL("tskv\t"
                                 "tskv_format=passport-ysa-log\t"
                                 "mode=fingerprint_external_dump\t"
                                 "namespace=kek\t"
                                 "unixtime=100500.007\t"
                                 "user_port=lol\t"
                                 "user_ip=kek\t"
                                 "user_agent_info_mega_data=asdklas\\n\\t\"aosidas\t"
                                 "etag_euid=\t"
                                 "etag_ip=\t"
                                 "etag_yandexuid=\t"
                                 "etag_malformed=0\t"
                                 "yandexuid=uid\\n1\t"
                                 "status=ok\t"
                                 "incoming_packet_count=16843009\t"
                                 "no_ts_opt_count=16843009\t"
                                 "in_tls=1\t"
                                 "tls_client_hello_recvd=1\t"
                                 "tls_client_hello_length=16843009\t"
                                 "syn_opt_hash=16843009\t"
                                 "syn_quirks=16843009\t"
                                 "syn_opt_eol_pad=1\t"
                                 "syn_ip_opt_len=1\t"
                                 "syn_ttl=1\t"
                                 "syn_mss=16843009\t"
                                 "syn_win=257\t"
                                 "syn_win_type=1\t"
                                 "syn_win_scale=257\t"
                                 "syn_quirk_ecn=1\t"
                                 "syn_quirk_df=0\t"
                                 "syn_quirk_nz_id=0\t"
                                 "syn_quirk_zero_id=0\t"
                                 "syn_quirk_nz_mbz=0\t"
                                 "syn_quirk_flow=0\t"
                                 "syn_quirk_zero_seq=0\t"
                                 "syn_quirk_nz_ack=0\t"
                                 "syn_quirk_zero_ack=0\t"
                                 "syn_quirk_nz_urg=0\t"
                                 "syn_quirk_urg=1\t"
                                 "syn_quirk_push=0\t"
                                 "syn_quirk_opt_zero_ts1=1\t"
                                 "syn_quirk_opt_nz_ts2=0\t"
                                 "syn_quirk_opt_eol_nz=0\t"
                                 "syn_quirk_opt_exws=0\t"
                                 "syn_quirk_opt_bad=0\t"
                                 "no_ts_opt_percent=1.00\t"
                                 "ssl_num_ciphersuites=0\t"
                                 "ssl_ciphersuites=\t"
                                 "ssl_num_compression_methods=0\t"
                                 "ssl_compression_methods=\t"
                                 "ssl_num_extensions=0\t"
                                 "ssl_extensions=\t"
                                 "ssl_extensions_values=\t"
                                 "ssl_protocol_version=0000\t"
                                 "ssl_client_version=0000\n",
                                 TTestStatboxLogEntry::LogOk(
                                     resp,
                                     TInstant::Seconds(100500) + TDuration::MilliSeconds(7)));
    }

    Y_UNIT_TEST(common) {
        TTestStatboxLogEntry statbox;
        statbox.LogCommon("kek", TInstant::Seconds(1005) + TDuration::MilliSeconds(7));

        UNIT_ASSERT_VALUES_EQUAL("tskv\t"
                                 "tskv_format=passport-ysa-log\t"
                                 "mode=fingerprint_external_dump\t"
                                 "namespace=kek\t"
                                 "unixtime=1005.007",
                                 statbox.Builder_.Str());
    }

    Y_UNIT_TEST(headers) {
        NCommon::THttpHeaders headers;
        headers["X-Real-ip"] = "kek";
        headers["X-real-Port"] = "lol";
        headers["X-Ya-foo"] = "bar";
        headers["X-Server-Port"] = "ba\nr";
        headers["X-Server-Ip"] = "adasd";
        headers["Host"] = "asdasdasdas";
        headers["Cookie"] = "123123asdasdasdas";
        headers["User-Agent"] = "789";

        TTestStatboxLogEntry statbox;
        statbox.LogHeaders(headers);

        UNIT_ASSERT_VALUES_EQUAL("user_agent_raw=789\t"
                                 "user_port=lol\t"
                                 "user_ip=kek",
                                 statbox.Builder_.Str());
    }

    Y_UNIT_TEST(tls) {
        TTlsData data;
        data.Ciphersuites = {
            "ab",
            "lo",
            "ke",
            "v\t",
            "\nq",
        };
        data.CompressionMethods = "hs,f";
        data.Extensions = {
            {"au", ""},
            {"ef", "sdfsdfsfsadfsd"},
            {"cd", ""},
        };
        data.ProtocolVersion = 0x0301;
        data.ClientVersion = 0x0303;

        TTestStatboxLogEntry statbox;
        TTlsLogEntry tls(statbox);

        tls.Log(data);
        UNIT_ASSERT_VALUES_EQUAL("ssl_num_ciphersuites=5\t"
                                 "ssl_ciphersuites=6162,6c6f,6b65,7609,0a71\t"
                                 "ssl_num_compression_methods=4\t"
                                 "ssl_compression_methods=104,115,44,102\t"
                                 "ssl_num_extensions=3\t"
                                 "ssl_extensions=6175,6566,6364\t"
                                 "ssl_extensions_values=,7364667364667366736164667364,\t"
                                 "ssl_protocol_version=0301\t"
                                 "ssl_client_version=0303",
                                 statbox.Builder_.Str());
        statbox.Builder_.Clear();

        data.IsProtocolVersionSuspicious = true;
        data.IsClientVersionSuspicious = true;
        data.IsRecordSizeSuspicious = true;
        data.IsHadshakeSizeSuspicious = true;
        data.IsSessionidSizeSuspicious = true;
        data.IsCiphersuitesSizeSuspicious = true;
        data.IsCompressionSizeSuspicious = true;
        data.IsAllExtensionsSizeSuspicious = true;
        data.IsExtensionSizeSuspicious = true;
        tls.Log(data);
        UNIT_ASSERT_VALUES_EQUAL("ssl_num_ciphersuites=5\t"
                                 "ssl_ciphersuites=6162,6c6f,6b65,7609,0a71\t"
                                 "ssl_num_compression_methods=4\t"
                                 "ssl_compression_methods=104,115,44,102\t"
                                 "ssl_num_extensions=3\t"
                                 "ssl_extensions=6175,6566,6364\t"
                                 "ssl_extensions_values=,7364667364667366736164667364,\t"
                                 "ssl_protocol_version=0301\t"
                                 "ssl_client_version=0303\t"
                                 "suspicious_ssl_protocol_version=1\t"
                                 "suspicious_ssl_client_version=1\t"
                                 "suspicious_ssl_record_size=1\t"
                                 "suspicious_ssl_handshake_size=1\t"
                                 "suspicious_ssl_sessionid_size=1\t"
                                 "suspicious_ssl_ciphersuite_size=1\t"
                                 "suspicious_ssl_compression_size=1\t"
                                 "suspicious_ssl_all_extensions_size=1\t"
                                 "suspicious_ssl_extension_size=1",
                                 statbox.Builder_.Str());
    }
}
