#include <passport/infra/daemons/ysa/src/uatraits.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NYsa;

Y_UNIT_TEST_SUITE(Uatraits) {
    class TUaTraitsProcessorTest: public TUaTraitsProcessor {
    public:
        using TUaTraitsProcessor::Filter;
        using TUaTraitsProcessor::TUaTraitsProcessor;
    };

    using TData = TMap<TString, TString>;
    static TData Translate(const TUaTraits::TData& data) {
        TData res;
        for (const auto& pair : data) {
            res.emplace(TString(pair.first), TString(pair.second));
        }
        return res;
    }

    Y_UNIT_TEST(run) {
        TUaTraitsProcessorTest p(ArcadiaSourceRoot() + "/passport/infra/daemons/ysa/ut/browser.xml");
        TUaTraits d = p.Fetch("Mozilla/5.0 (Linux; Android 9; Mi A2 Lite Build/PKQ1.180917.001) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.103 YaBrowser/18.7.1.595.00 Mobile Safari/537.36");

        UNIT_ASSERT_VALUES_EQUAL(
            TData({
                {"BrowserBase", "Chromium"},
                {"BrowserBaseVersion", "67.0.3396.103"},
                {"BrowserEngine", "WebKit"},
                {"BrowserEngineVersion", "537.36"},
                {"BrowserName", "YandexBrowser"},
                {"BrowserVersion", "18.7.1.595.00"},
                {"DeviceModel", "Mi A2 Lite"},
                {"DeviceName", "Mi A2 Lite"},
                {"DeviceVendor", "Xiaomi"},
                {"OSFamily", "Android"},
                {"OSVersion", "9"},
                {"isBrowser", "1"},
                {"isMobile", "1"},
                {"isTablet", "0"},
                {"isTouch", "1"},
            }),
            Translate(d.Data));

        d.Data["strange_data"] = "";
        d.Data["strange_data_2"] = "Unknown";
        d.Data["strange_data_3"] = "True";
        d.Data["strange_data_4"] = "False";
        TUaTraitsProcessorTest::Filter(d.Data);

        UNIT_ASSERT_VALUES_EQUAL(
            TData({
                {"BrowserBase", "Chromium"},
                {"BrowserBaseVersion", "67.0.3396.103"},
                {"BrowserEngine", "WebKit"},
                {"BrowserEngineVersion", "537.36"},
                {"BrowserName", "YandexBrowser"},
                {"BrowserVersion", "18.7.1.595.00"},
                {"DeviceModel", "Mi A2 Lite"},
                {"DeviceName", "Mi A2 Lite"},
                {"DeviceVendor", "Xiaomi"},
                {"OSFamily", "Android"},
                {"OSVersion", "9"},
                {"isBrowser", "1"},
                {"isMobile", "1"},
                {"isTablet", "0"},
                {"isTouch", "1"},
                {"strange_data_3", "1"},
                {"strange_data_4", "0"},
            }),
            Translate(d.Data));
    }
}
