
#### addrtotest
E-mail, который проверяется на принадлежность пользователю.<br/><br/>Аргумент обязателен, если в запросе присутствует аргумент [`emails`](#emails) со значением «testone». Игнорируется во всех остальных случаях.

#### aliases
Признак запроса алиасов аккаунта.<br/><br/>Поддерживаемые значения:<br/>**getsocial** — возвращается логин, автоматически сгенерированный для социального аккаунта.<br/>**getphonenumber** — возвращается [номер телефона вместо логина](https://help.yandex.ru/passport/authorization/phone-login.xml)<br/>**all** — возвращаются все известные алиасы аккаунта.<br/><br/>Также в значении параметра можно перечислить нужные типы алиасов по номерам через запятую, например `aliases=6,11.` <br/><br/> Полный список алиасов приведен в [таблице алиасов](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#aliases)<br/> Для получения алиасов аккаунта гранты не требуются.

#### attributes
Номера атрибутов аккаунта, которые следует вернуть в ответе. Полный список атрибутов приведен в [таблице атрибутов](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#db-attributes).<br/><br/>Чтобы запросить несколько атрибутов, следует перечислить их номера в значении параметра через запятую.

❗️ Некоторые атрибуты, такиe как персональные данные пользователя, требуют грантов для их чтения.

#### dbfields
Список имен полей в терминах старой базы Паспорта. <br/><br/> Это устаревший способ получения данных об аккаунте, информацию из паспортной базы данных рекомендуется запрашивать с помощью параметра [`attributes`](#attributes).<br/> Значения поддерживаемых полей старой базы вычисляются на основе атрибутов, неизвестные поля игнорируются.

❗️ Некоторые поля требуют грантов для чтения: это отдельные гранты, независимые от грантов на чтение атрибутов.

#### emails
**getall**/**getyandex**/**getdefault**/**testone**<br/><br/> Признак того, что в ответе следует вернуть список электронных адресов пользователя.<br/>Набор адресов в ответе возвращается в элементе `address-list` и зависит от значения аргумента:<br/>**getall** — возвращается список всех известных адресов пользователя, как внутренних, так и внешних.<br/>**getyandex** — возвращается список адресов пользователя на Яндексе<br/>**getdefault** — возвращается e-mail по умолчанию для данного пользователя.<br/>**testone** — возвращается адрес, указанный в значении аргумента [`addrtotest`](#addrtotest), если этот адрес принадлежит учетной записи. Если указанный адрес не принадлежит пользователю, возвращается пустой список.<br/><br/>Более подробно см. раздел [получение e-mail адресов пользователя](../concepts/emails.md).

#### email_attributes
Список номеров почтовых атрибутов, которые следует вернуть в ответе. Полный список атрибутов приведен [в таблице атрибутов e-mail-ов](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#section_gyv_v5f_2hb). Аргумент необходимо передавать совместно с аргументом [`getemails`](#getemails).<br/>Чтобы запросить несколько атрибутов, следует перечислить их номера в значении параметра через запятую.<br/><br/> Гранты на получение атрибутов привязанных e-mail-ов не требуются.

#### getemails
Признак того, что в ответе следует вернуть список [атрибутов внешних адресов пользователя](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#section_gyv_v5f_2hb).<br/> Возможные значения:<br/>**all** — возвращает атрибуты для всех известных почтовых адресов.<br/><br/>Номера почтовых атрибутов перечисляются в аргументе [`email_attributes`](#email_attributes). Если аргумент [`email_attributes`](#email_attributes) не передан, в ответе появится только список идентификаторов e-mail-ов.<br/><br/>Более подробно см. раздел [получение e-mail адресов пользователя](../concepts/emails.md).

#### get_family_info
**yes**/**true**/**1**

Добавляет в ответ [краткую информацию о семье](#family_info).

#### getphones
**all**/**bound**<br/><br/> Признак того, что в ответе следует вернуть список [атрибутов привязанных телефонов пользователя](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#section_kbk_b5f_2hb).<br/> Возможные значения:<br/>**all** — возвращает все сохраненные в профиле телефоны.<br/>**bound** — возвращает только привязанные (подтвержденные) телефоны.<br/><br/>Номера телефонных атрибутов перечисляются в аргументе [`phone_attributes`](#phone_attributes). Если аргумент [`phone_attributes`](#phone_attributes) не передан, в ответе появится только список идентификаторов телефонов.<br/><br/>Более подробно см. раздел [получение телефонов пользователя](../concepts/phones.md).

#### get_plus_subscriber_state

Позволяет получить список пользовательских фичей в поле [plus_subscriber_state](#plus_subscriber_state).

Поддерживаемые значения:
  * **all** - получить все фичи пользователя

#### get_public_id
**yes**/**true**/**1** <br/><br/> Признак наличия в ответе [публичного идентификатора пользователя](../concepts/ugc.md#public-id).

#### get_public_name
**yes**/**true**/**1** <br/><br/> Признак наличия в ответе [публичного имени пользователя](../concepts/ugc.md#public-name). Данный параметр обрабатывается только совместно с параметром [regname](#regname), публичное имя добавляется внутри блока `display_name`.

❗️ Поскольку публичное имя может содержать персональные данные, параметр **требует гранта `allow_get_public_name`.**

#### format
**xml**/**json**<br/><br/>Ожидаемый формат ответа. Значение по-умолчанию - **xml**.

#### is_display_name_empty
**yes**/**true**/**1** <br/><br/> Добавляет в секцию [display_name](#display_name) поле [display_name_empty](#display_name-greaterdisplay_name_empty)

#### phone_attributes
Список номеров телефонных атрибутов, которые следует вернуть в ответе. Полный список атрибутов приведен [в таблице атрибутов телефонов](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#section_kbk_b5f_2hb). Аргумент необходимо передавать совместно с аргументом [`getphones`](#getphones).<br/><br/>Чтобы запросить несколько атрибутов, следует перечислить их номера в значении параметра через запятую.

❗️ Атрибуты, содержащие полный телефонный номер, являются персональными данными и **требуют отдельного гранта.**

#### regname
**yes**/**true**/**1** <br/><br/> Признак того, что в ответе следует вернуть дополнительные данные: имя пользователя для отображения в интерфейсе, аватар и социальный профиль. Дополнительные данные появятся в блоке `display_name`.<br/><br/>Для получения имени гранты не требуются.
