### Элементы ответа

#### bruteforce_policy
Рекомендованное поведение сервиса для данной попытки авторизации. Используется при вызове [второй версии метода](../../methods/login.md#ver2).<br/><br/>Поведение описывается вложенными элементами.

#### bruteforce_policy->captcha
Признак того, что превышен лимит неудачных аутентификаций и сервису рекомендуется показать пользователю капчу.

#### bruteforce_policy->password_expired
Признак того, что истек срок действия пароля. Сервису рекомендуется перенаправить пользователя в Паспорт (по адресу `https://passport.yandex.ru/passport?mode=changepass`) для смены пароля.<br/>Возвращается только для пользователей, подписанных на сервис strongpwd (SID 67).

#### comment
Пояснение [статуса учетной записи](#login_status) и [статуса пароля](#password_status). Например, при статусе учетной записи «NOT_FOUND» элемент содержит значение «Login not found»). Возвращается при вызове [второй версии метода](../../methods/login.md#ver2).<br/>При успешной аутентификации элементу присваивается значение «ОК».<br/><br/>Значение предназначено для внутреннего использования (например, для отладки или записи в лог). Пользователю следует сообщать об ошибке в контексте операции, которую он пытался произвести.

#### connection_id
Идентификатор соединения, по которому был авторизован пользователь. С его помощью можно закрыть авторизованное соединение, которое остается активным после удаления или блокировки аккаунта.<br/><br/>Включается в ответ, если в аргументе [password](../../methods/login.md#password) был указан правильный пароль приложения.

#### error
Пояснение [статуса аутентификации](#status). Например, при статусе аутентификации «INVALID» элемент может содержать значение «Bad password». При успешной аутентификации элементу присваивается значение «ОК».<br/>Возвращается при вызове [первой версии метода](../../methods/login.md#ver1).<br/><br/>Значение предназначено для внутреннего использования (например, для отладки или записи в лог). Пользователю следует сообщать об ошибке в контексте операции, которую он пытался произвести.

#### login_status
Статус учетной записи. Используется при вызове [второй версии метода](../../methods/login.md#ver2).<br/>Возможные статусы аутентификации:<br/>- 1 (`VALID`) — учетная запись найдена и активна.<br/>- 3 (`NOT_FOUND`) — учетная запись не найдена.<br/>- 4 (`DISABLED`) — учетная запись найдена, но заблокирована.

#### password_status
Cтатус проверки пароля. Используется при вызове [второй версии метода](../../methods/login.md#ver2).<br/>Возможные статусы пароля:<br/>- 0 (`UNKNOWN`) — пароль не проверен. Устанавливается, если указанный аккаунт не был найден.<br/>- 1 (`VALID`) — пароль верный.<br/>- 2 (`BAD`) — пароль неверный или отсутствует.<br/>- 4 (`SECOND_STEP_REQUIRED`) — пароль верный, но требуется дополнительное подтверждение входа вторым фактором.

#### status
Текстовый статус аутентификации (результат проверки пары логин/пароль). Возвращается при вызове [первой версии метода](../../methods/login.md#ver1).<br/><br/>Возможные статусы аутентификации, с идентификаторами:<br/>- 0 (`VALID`) — аутентификация пользователя по логину и паролю успешна.<br/>- 1 (`DISABLED`) — пара логин/пароль верная, но аккаунт заблокирован.<br/>- 2 (`INVALID`) — возвращается в двух случаях:<br/>        * логин и/или пароль указаны неверно;<br/>        * лимит неудачных попыток аутентификации превышен, но у сервиса нет [грантов](../../concepts/getting-access.md#holes-grants) на показ капчи.<br/>- 3 (`SHOW_CAPTCHA`) — в ответ на попытку авторизации следует показать капчу.<br/>Статус может быть возвращен только тем сервисам, у которых есть гранты на показ капчи. Остальным сервисам в ответ на тот же запрос возвращается статус `INVALID`.<br/>    См. также раздел [Политика защиты от подбора паролей](../../concepts/bruteforce-policy.md).<br/>- 6 (`EXPIRED`) — аутентификация пользователя успешна, но срок действия пароля истек. Необходимо перенаправить пользователя на Паспорт для [смены пароля](https://doc.yandex-team.ru/Passport/passport-modes/reference/changepass.html) (режим `changepass`).<br/>Возвращается только для пользователей, подписанных на сервис strongpwd (SID 67).

#### user_ticket
User-тикет пользователя.<br/><br/>Включается в ответ, если был передан параметр [`get_user_ticket`](../../methods/login.md#get_user_ticket), в заголовке [`X-Ya-Service-Ticket`](../../methods/login.md#x-ya-service-ticket-header) был указан правильный Service-тикет и проверка пароля прошла успешно.
