### Элементы ответа

#### error
Пояснение элемента [`status`](#status). Например, при статусе аутентификации «INVALID» элемент `error` может содержать значение «expired_token».<br/><br/>Значение предназначено только для внутреннего использования (например, для отладки или записи в лог). Пользователю следует сообщать об ошибке в контексте операции, которую он пытался произвести.

#### connection_id
Идентификатор соединения, по которому был авторизован пользователь. С его помощью можно закрыть авторизованное соединение, которое остается активным после удаления или блокировки аккаунта.

#### login_id
Расширенный идентификатор соединения, по которому был авторизован пользователь. В отличие от [`connection_id`](#connection_id), `login_id` сохраняется при обмене куки на токен и обратно, т.е. цепочка кук и/или токенов из одной сессии будет иметь один `login_id`.

#### oauth
(В XML - `OAuth`) Данные о переданном в запросе токене.

#### oauth->client_ctime
Время регистрации приложения, запросившего токен.

#### oauth->client_icon
URL иконки OAuth-приложения.

#### oauth->client_id
Идентификатор приложения в Яндекс.OAuth.

#### oauth->client_homepage
URL домашней страницы OAuth-приложения.

#### oauth->client_name
Название OAuth-приложения.

#### oauth->ctime
Время первой выдачи токена.

#### oauth->expire_time
Время, когда срок жизни токена закончится, если он не будет продлен.

#### oauth->issue_time
Время последней выдачи токена.

#### oauth->is_ttl_refreshable
Признак того, что срок жизни токена продляется при проверке.

#### oauth->device_id
Идентификатор устройства, для которого был выдан токен.<br/><br/>Использование индивидуальных токенов для устройств описано в [документации OAuth](https://yandex.ru/dev/oauth/doc/dg/concepts/device-token.html).

#### oauth->device_name
Имя устройства, для которого был выдан токен.<br/><br/>Использование индивидуальных токенов для устройств описано в документации OAuth.

#### oauth->scope
Набор прав, которые должны быть доступны приложению, предъявившему токен в результате авторизации.

#### oauth->token_id
Уникальный идентификатор токена.

#### oauth->uid
UID аккаунта, для которого был выдан токен.

#### status
Статус проверки OAuth-токена.<br/><br/>Возможные статусы токена, с идентификаторами:<br/>- 0 (`VALID`) — токен активен.<br/>- 4 (`DISABLED`) — OAuth-токен активен, но аккаунт владельца токена заблокирован.<br/>- 5 (`INVALID`) — OAuth-токен сформирован неверно, или просрочен.

#### user_ticket
User-тикет пользователя.<br/><br/>Включается в ответ, если был передан параметр [`get_user_ticket`](../../methods/oauth.md#get_user_ticket), в заголовке [`X-Ya-Service-Ticket`](../../methods/oauth.md#x-ya-service-ticket-header) был указан правильный Service-тикет и проверка токена прошла успешно.
